% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoins.R
\name{getCoins}
\alias{getCoins}
\title{Get historic crypto currency market data}
\usage{
getCoins(coin = NULL)
}
\arguments{
\item{coin}{Name, symbol or slug of crypto currency}

\item{...}{No arguments, return all coins}
}
\value{
Crypto currency historic OHLC market data in a dataframe:
  \item{slug}{Coin url slug}
  \item{symbol}{Coin symbol}
  \item{name}{Coin name}
  \item{date}{Market date}
  \item{ranknow}{Current Rank}
  \item{open}{Market open}
  \item{high}{Market high}
  \item{low}{Market low}
  \item{close}{Market close}
  \item{volume}{Volume 24 hours}
  \item{market}{USD Market cap}
  \item{close_ratio}{Close rate, min-maxed with the high and low values that day}
  \item{spread}{Volatility premium, high minus low for that day}

This is the main function of the crypto package. If you want to retrieve
ALL coins then do not pass a argument to getCoins(), or pass the coin name.

Please note that the doSNOW package is required to load the progress bar on
both linux and macOS systems as the doParallel package does not support it.
}
\description{
Scrape the crypto currency historic market tables from
Coinmarketcap <https://coinmarketcap.com> and display
the results in a date frame. This can be used to conduct
analysis on the crypto financial markets or to attempt
to predict future market movments or trends.
}
\examples{
# retrieving market history for specific crypto currency

coin <- "kin"
kin_coins <- listCoins(coin)

\dontrun{

# retrieving market history for ALL crypto currencies

all_coins <- getCoins()
}

}
