% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunchy-ui.R
\name{crunchyPublicBody}
\alias{crunchyPublicBody}
\alias{crunchyUnauthorizedBody}
\title{Alternate UIs for unauthenticated and unauthorized users}
\usage{
crunchyPublicBody(...)

crunchyUnauthorizedBody(...)
}
\arguments{
\item{...}{UI elements for your app, to be conditionally rendered}
}
\value{
An empty string; these functions are called for their side effects of
registering the UI elements so that \code{crunchyServer()} can render them as
appropriate.
}
\description{
\code{\link[=crunchyServer]{crunchyServer()}} and \code{\link[=crunchyBody]{crunchyBody()}} allow you to protect your app with
Crunch authentication and authorization. Add these UI contents to your
\code{\link[shiny:shinyUI]{shiny::shinyUI()}} body to display different content for visitors who are
not authenticated with Crunch (\code{crunchyPublicBody()}) or who are
authenticated but not authorized to access your app
(\code{crunchyUnauthorizedBody}).
}
\examples{
\dontrun{
# This is the example from crunchyBody(), adding these alternate bodies:
shinyUI(fluidPage(
    tags$head(
        # This is content that will always be rendered
        tags$title("My secure app")
    ),
    crunchyBody(
        # This is content that only is rendered if the user is authorized
        fluidRow(
            column(6, h1("Column 1")),
            column(6, h1("Column 2"))
        )
    ),
    crunchyPublicBody(
        # This is shown to visitors who are not logged into Crunch at all
        h1("Please log into Crunch.")
    ),
    crunchyUnauthorizedBody(
        # This is for Crunch users who don't meet your authorization criteria
        # Perhaps they don't have access to a particular dataset
        h1("You don't have access to this app."),
        tags$div("Contact your_admin@example.com.")
    )
))
}
}
\seealso{
\code{\link[=crunchyBody]{crunchyBody()}}; \code{\link[=setCrunchyAuthorization]{setCrunchyAuthorization()}} for governing who is
authorized to view your app.
}
