% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{withCrunchyProgress}
\alias{withCrunchyProgress}
\title{Display progress from Crunch API processes}
\usage{
withCrunchyProgress(expr, ...)
}
\arguments{
\item{expr}{Code to evaluate}

\item{...}{Additional arguments passed to \code{\link[shiny:withProgress]{shiny::withProgress()}}}
}
\value{
The result of \code{expr}
}
\description{
Some potentially large operations, such as imports and exports, report
progress in the Crunch API. In an interactive R session, they print a text
progress bar. This context, which wraps \code{\link[shiny:withProgress]{shiny::withProgress()}}, reports that
Crunch API progress up to the Shiny web app.
}
\examples{
\dontrun{
withCrunchyProgress(
    ds <- newDataset(df),
    message = "Importing..."
)
}
}
