% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataset.R, R/shoji.R, R/teams.R, R/variable.R
\docType{methods}
\name{delete}
\alias{delete}
\alias{delete,ANY-method}
\alias{delete,CategoricalArrayVariable-method}
\alias{delete,CrunchDataset-method}
\alias{delete,CrunchTeam-method}
\alias{delete,CrunchVariable-method}
\alias{delete,ShojiObject-method}
\title{Delete a Crunch object from the server}
\usage{
\S4method{delete}{CrunchDataset}(x, confirm = requireConsent() |
  is.readonly(x), ...)

\S4method{delete}{ShojiObject}(x, ...)

\S4method{delete}{ANY}(x, ...)

\S4method{delete}{CrunchTeam}(x, confirm = requireConsent(), ...)

\S4method{delete}{CrunchVariable}(x, ...)

\S4method{delete}{CategoricalArrayVariable}(x, ...)
}
\arguments{
\item{x}{a Crunch object}

\item{confirm}{logical: should the user be asked to confirm deletion.
Option available for datasets and teams only. Default is \code{TRUE} if in
an interactive session. You can avoid the confirmation prompt if you delete
\code{with(\link{consent})}.}

\item{...}{additional arguments, in the generic}
}
\description{
These methods delete entities, notably Datasets and Variables within them,
from the server. This action is permanent and cannot be undone, so it
should not be done lightly. Consider instead using \code{archive}
for datasets and \code{\link{hide}} for variables
}
\seealso{
\code{\link{hide}} \code{\link{deleteDataset}}
}

