% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-data-frame.R
\name{dataset-to-R}
\alias{dataset-to-R}
\alias{as.data.frame.CrunchDataset}
\alias{as.data.frame.CrunchDataFrame}
\title{as.data.frame method for CrunchDataset}
\usage{
\method{as.data.frame}{CrunchDataset}(
  x,
  row.names = NULL,
  optional = FALSE,
  force = FALSE,
  categorical.mode = "factor",
  row.order = NULL,
  include.hidden = TRUE,
  ...
)

\method{as.data.frame}{CrunchDataFrame}(
  x,
  row.names = NULL,
  optional = FALSE,
  include.hidden = attr(x, "include.hidden"),
  array_strategy = c("alias", "qualified_alias", "packed"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{CrunchDataset} or \code{CrunchDataFrame}}

\item{row.names}{part of \code{as.data.frame} signature. Ignored.}

\item{optional}{part of \code{as.data.frame} signature. Ignored.}

\item{force}{logical: actually coerce the dataset to \code{data.frame}, or
leave the columns as unevaluated promises. Default is \code{FALSE}.}

\item{categorical.mode}{what mode should categoricals be pulled as? One of
factor, numeric, id (default: factor)}

\item{row.order}{vector of indices. Which, and their order, of the rows of
the dataset should be presented as (default: \code{NULL}). If \code{NULL}, then the
Crunch Dataset order will be used.}

\item{include.hidden}{logical: should hidden variables be included? (default: \code{TRUE})}

\item{...}{additional arguments passed to \code{as.data.frame} (default method).}

\item{array_strategy}{Strategy to import array variables: "alias" (the default)
reads them as flat variables with the subvariable aliases, unless there are duplicate
aliases in which case they are qualified in brackets after the array alias,
like "array_alias[subvar_alias]". "qualified_alias" always uses the bracket notation.
"packed" reads them in what the tidyverse calls "packed" data.frame columns, with the
alias from the array variable, and subvariables as the columns of the data.frame.}

\item{verbose}{Whether to output a message to the console when subvariable aliases
are qualified when array_strategy="alias" (defaults to TRUE)}
}
\value{
When called on a \code{CrunchDataset}, the method returns an object of
class \code{CrunchDataFrame} unless \code{force = TRUE}, in which case the return is a
\code{data.frame}. For \code{CrunchDataFrame}, the method returns a \code{data.frame}.
}
\description{
This method is defined principally so that you can use a \code{CrunchDataset} as
a \code{data} argument to other R functions (such as \code{\link[stats:lm]{stats::lm()}}) without
needing to download the whole dataset. You can, however, choose to download
a true \code{data.frame}.
}
\details{
By default, the \code{as.data.frame} method for \code{CrunchDataset} does not return a
\code{data.frame} but instead \code{CrunchDataFrame}, which behaves like  a
\code{data.frame} without bringing the whole dataset into memory.
When you access the variables of a \code{CrunchDataFrame},
you get an R vector, rather than a \code{CrunchVariable}. This allows modeling functions
that require select columns of a dataset to retrieve only those variables from
the remote server, rather than pulling the entire dataset into local
memory.

If you call \code{as.data.frame()} on a \code{CrunchDataset} with \code{force = TRUE}, you
will instead get a true \code{data.frame}. You can also get this \code{data.frame} by
calling \code{as.data.frame} on a \code{CrunchDataFrame} (effectively calling
\code{as.data.frame} on the dataset twice)

When a \code{data.frame} is returned, the function coerces Crunch Variable
values into their R equivalents using the following rules:
\itemize{
\item Numeric variables become numeric vectors
\item Text variables become character vectors
\item Datetime variables become either \code{Date} or \code{POSIXt} vectors
\item Categorical variables become either factors with
levels matching the Crunch Variable's categories (the default), or, if
\code{categorical.mode} is specified as "id" or "numeric", a numeric vector of
category ids or numeric values, respectively
\item Array variables (Categorical Array, Multiple Response) can be decomposed into
their constituent categorical subvariables or put in 'packed' data.frame columns,
see the \code{array_strategy} argument.
}

Column names in the \code{data.frame} are the variable/subvariable aliases.
}
\seealso{
\code{\link[=as.vector]{as.vector()}}
}
