% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-index-table.R
\name{index.table}
\alias{index.table}
\title{Calculate an index table for a CrunchCube}
\usage{
index.table(x, margin, baseline)
}
\arguments{
\item{x}{A CrunchCube to calculate index table for}

\item{margin}{which margin to index against (1 for rows, 2 for columns)}

\item{baseline}{an arbitrary set of proportions to compare the table given in
\code{x} to. Useful for comparing two separate cubes. \code{baseline} must have the
same length as the extent of the dimension given in \code{margin}.}
}
\value{
an array of percentages indexed to the margin provided
}
\description{
Index tables are percentages of percentages. They take the percentage from
\code{prop.table(cube, margin)} and, by default, divide that by the proportions of
the other margin. The \code{baseline} argument can be used to provide baseline
proportions to compare against.
}
\details{
\code{index.table()} is only implemented for 2 dimensional cubes. If you need to
calculate indexes for a higher dimension Cube, please slice the cube first.
}
\examples{
\dontrun{
 cube_object
 #    v7
 # v4  C E
 #   B 5 2
 #   C 5 3
 index.table(cube_object, 1)
 #    v7
 # v4         C         E
 #   B 107.1429  85.71429
 #   C  93.7500 112.50000
 index.table(cube_object, 2)
 #    v7
 # v4    C   E
 #   B 100  80
 #   C 100 120
 index.table(cube_object, 2, c(0.6, 0.4))
 #    v7
 # v4          C         E
 #   B  83.33333  66.66667
 #   C 125.00000 150.00000
}

}
