% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/new-dataset.R
\name{newDatasetFromFile}
\alias{newDatasetFromFile}
\title{Upload a file to Crunch to make a new dataset}
\usage{
newDatasetFromFile(file, name = basename(file),
  useAlias = default.useAlias(), ...)
}
\arguments{
\item{file}{character, the path to a file to upload. This should either be
a .csv or .sav (SPSS) file.}

\item{name}{character, the name to give the new Crunch dataset. Default is
the file name}

\item{useAlias}{logical whether variable alias or name should be used as R
variable names when the dataset is returned. Default is TRUE, meaning alias.
They're more computer friendly.}

\item{...}{additional arguments passed to \code{ \link{createDataset}}}
}
\value{
On success, an object of class \code{CrunchDataset}.
}
\description{
Use this import method if you have an SPSS data file. Reading such a file
into R as a data.frame will result in lost metadata. You can just send it
directly to Crunch and let the server process it.
}

