% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crumble.R
\name{crumble}
\alias{crumble}
\title{Flexible and general mediation analysis}
\usage{
crumble(
  data,
  trt,
  outcome,
  mediators,
  moc = NULL,
  covar,
  obs = NULL,
  id = NULL,
  d0 = NULL,
  d1 = NULL,
  effect = c("RT", "N", "RI", "O"),
  weights = rep(1, nrow(data)),
  learners = "glm",
  nn_module = sequential_module(),
  control = crumble_control()
)
}
\arguments{
\item{data}{[\code{data.frame}]\cr
A \code{data.frame} in wide format containing all necessary variables
for the estimation problem.}

\item{trt}{[\code{character}]\cr
A vector containing the column names of treatment variables.}

\item{outcome}{[\code{character(1)}]\cr
The column name of the outcome variable.}

\item{mediators}{[\code{character}]\cr
A vector containing the column names of the mediator variables.}

\item{moc}{[\code{character}]\cr
An optional vector containing the column names of the mediator-outcome confounders.}

\item{covar}{[\code{character}]\cr
An vector containing the column names of baseline covariates to be
controlled for.}

\item{obs}{[\code{character(1)}]\cr
An optional column name (with values coded as 0 or 1) for whether or not the \code{outcome} is observed.
Must be provided if there is missingness in the outcome! Default is \code{NULL}.}

\item{id}{[\code{character(1)}]\cr
An optional column name containing cluster level identifiers.}

\item{d0}{[\code{closure}]\cr
A two argument function that specifies how treatment variables should be shifted.
See examples for how to specify shift functions for continuous, binary, and categorical exposures.}

\item{d1}{[\code{closure}]\cr
A two argument function that specifies how treatment variables should be shifted.
See examples for how to specify shift functions for continuous, binary, and categorical exposures.}

\item{effect}{[\code{character(1)}]\cr
The type of effect to estimate. Options are \code{"RT"} for recanting twins,
\code{"N"} for natural effects, \code{"RI"} for randomized interventional effects,
and \code{"O"} for organic effects.
If \code{"RT"} or \code{"RI"} is selected, \code{moc} must be provided.
If \code{"N"} or \code{"O"} is selected, \code{moc} must be \code{NULL}.}

\item{weights}{[\code{numeric}]\cr
A optional vector of survey weights.}

\item{learners}{[\code{character}]\cr
A vector of \code{mlr3superlearner} algorithms
for estimation of the outcome regressions. Default is \code{"glm"}, a main effects GLM.}

\item{nn_module}{[\code{function}]\cr A function that returns a neural network module.}

\item{control}{[\code{crumble_control}]\cr
Control parameters for the estimation procedure. Use \code{crumble_control()} to set these values.}
}
\value{
A \code{crumble} object containing the following components:
\item{estimates}{A list of parameter estimates.}
\item{outcome_reg}{Predictions from the outcome regressions.}
\item{alpha_n}{A list of density ratio estimates.}
\item{alpha_r}{A list of density ratio estimates.}
\item{fits}{A list of the fitted values from the outcome regressions.}
\item{call}{The matched call.}
\item{effect}{The estimated effect type.}
}
\description{
General estimator for common mediation causal effects, including recanting
twins, natural effects, organic effects, and randomized interventional
effects. Interventions are specified using modified treatment policies.
Nuisance parameters are estimated using the 'super learner' algorithm and
'Riesz learning'. Supports binary, categorical, and continuous exposures.
}
\examples{
\donttest{
if (require("mma") && torch::torch_is_installed()) {
	library(mma)
	data(weight_behavior)

	weight_behavior <- na.omit(weight_behavior)

	res <- crumble(
		data = weight_behavior,
		trt = "sports",
		outcome = "bmi",
		covar = c("age", "sex", "tvhours"),
		mediators = c("exercises", "overweigh"),
		moc = "snack",
		d0 = \(data, trt) factor(rep(1, nrow(data)), levels = c("1", "2")),
		d1 = \(data, trt) factor(rep(2, nrow(data)), levels = c("1", "2")),
		learners = c("mean", "glm"),
		nn_module = sequential_module(),
		control = crumble_control(crossfit_folds = 1L, zprime_folds = 5L, epochs = 10L)
	)

	print(res)
	tidy(res)
}
}
}
