% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitest_helpers.R
\name{multitest_evaluation}
\alias{multitest_evaluation}
\title{Create an evaluation of multiple tests}
\usage{
multitest_evaluation(evaluations, iterations, cross_validation,
  preserve_distribution, name, method, problem)
}
\arguments{
\item{evaluations}{List of \code{evaluation} objects}

\item{iterations}{Numeric. Number of times the test was conducted}

\item{cross_validation}{Logical. Was cross-validation used as a sampling strategy?}

\item{preserve_distribution}{Logical. Was preservation of class distribution between training and holdout set attempted?}

\item{name}{Name of the test}

\item{method}{Name of the method used in the test}

\item{problem}{Name of the machine learning problem}
}
\value{
An object of type 'multitest_evaluation'. Attributes are:
\tabular{ll}{  
 {\code{evaluations}}\tab {List of evaluations}\cr
 {\code{iterations}}\tab {Number of times the test was conducted}\cr
 {\code{cross_validation}}\tab {Was cross-validation used as a sampling strategy?}\cr
 {\code{preserve_distribution}}\tab {Was preservation of class distribution between training and holdout set attempted?}\cr
 {\code{name}} \tab{Name of the method used in the test}\cr
 {\code{problem}} \tab {Name of the machine learning problem}
}
}
\description{
Creates an object of class 'multitest_evaluation'
}

