% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_helpers.R
\name{apply_levels}
\alias{apply_levels}
\title{Converts the column factor levels in \code{df} to those in \code{df_reference}}
\usage{
apply_levels(df, df_reference)
}
\arguments{
\item{df}{The df that is to be releveled}

\item{df_reference}{A reference df, which column levels will be applied to df if that column is a factor}
}
\value{
A data.frame where all factor's levels where changed. Through applying new levels, NAs could have been introduced
}
\description{
Each column in the result is a factor with the values of df and the levels of df_reference. 
This means that if there are levels in df_to_change that are not in df_reference, NAs will be introduced.
The main use of this function is in classifier problems, where the training and the test set need to have equal factors.
To work, all names(df_reference) need to be %in% names(df)
}

