% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_crs.R
\name{suggest_top_crs}
\alias{suggest_top_crs}
\title{Return the CRS code for a "best-fit" projected coordinate reference system}
\usage{
suggest_top_crs(input, units = NULL, inherit_gcs = TRUE, output = "epsg")
}
\arguments{
\item{input}{An input spatial dataset of class \code{"sf"}, \code{"Spatial*"}, or \code{"RasterLayer"}.}

\item{units}{(optional) The measurement units used by the returned coordinate reference system.}

\item{inherit_gcs}{if \code{TRUE} (the default), the function will return a CRS suggestion that uses the geographic coordinate system of the input layer.  Otherwise, the output may use a different geographic coordinate system from the input.}

\item{output}{one of \code{"epsg"}, for the EPSG code, or \code{"proj4string"}, for the proj4string syntax.}
}
\value{
The EPSG code or proj4string for the output coordinate reference system.
}
\description{
Return the EPSG code or proj4string syntax for the top-ranking projected coordinate reference system returned by \code{suggest_crs()}.  This function should be used with caution and is recommended for interactive work rather than in production data pipelines.
}
\examples{
\dontrun{

# Let's say we are working with a demographic dataset from the US Census:
library(tidycensus)
library(ggplot2)
library(sf)
library(crsuggest)

tx_income <- get_acs(
  geography = "county",
  variables = "B19013_001",
  state = "TX",
  geometry = TRUE
)

# We can use `suggest_top_crs()` to return the EPSG code of the "top" suggested CRS
# for statewide mapping of Texas
tx_crs <- suggest_top_crs(tx_income)

# The returned CRS is EPSG code 3083, NAD83 / Texas Centric Albers Equal Area.
# This code can be used for visualization:

ggplot(tx_income, aes(fill = estimate)) +
  geom_sf() +
  coord_sf(crs = tx_crs)

# Alternatively, we can transform the CRS of our sf object directly:

tx_projected <- st_transform(tx_income, tx_crs)
}
}
