% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsx.R
\name{as_workbook}
\alias{as_workbook}
\title{Converts a \code{crosstable} object into a formatted, savable \code{openxlsx} workbook.}
\usage{
as_workbook(
  x,
  show_test_name = TRUE,
  by_header = NULL,
  keep_id = FALSE,
  generic_labels = list(id = ".id", variable = "variable", value = "value", total =
    "Total", label = "label", test = "test", effect = "effect"),
  ...
)
}
\arguments{
\item{x}{the result of \code{\link[=crosstable]{crosstable()}} or a list of crosstables}

\item{show_test_name}{in the \code{test} column, show the test name}

\item{by_header}{a string to override the \code{by} header}

\item{keep_id}{whether to keep the \code{.id} column}

\item{generic_labels}{names of the crosstable default columns}

\item{...}{unused}
}
\value{
an \code{openxlsx} workbook containing the crosstable(s)
}
\description{
Converts a \code{crosstable} object into a formatted, savable \code{openxlsx} workbook.
}
\examples{
library(openxlsx)
target = tempfile(fileext=".xlsx")

x=crosstable(mtcars2, c(mpg, vs, gear), total=TRUE, test=TRUE)
as_workbook(x, keep_id=TRUE) \%>\%
    saveWorkbook(file=target)
if(interactive()) browseURL(target)

target = tempfile(fileext=".xlsx")
x2=list(iris=crosstable(iris2), crosstable(mtcars2))
as_workbook(x2, keep_id=TRUE) \%>\%
    saveWorkbook(file=target)
if(interactive()) browseURL(target)
}
\author{
Dan Chaltiel
}
