% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_barplot.R
\name{build_top_metaplot}
\alias{build_top_metaplot}
\title{Top metadata-hap bar plot}
\usage{
build_top_metaplot(HapObject, epsilon, hide_labels = FALSE)
}
\arguments{
\item{HapObject}{Haplotype object created by run_haplotyping()}

\item{epsilon}{Epsilon to visualize haplotyping results for.}

\item{hide_labels}{If TRUE, legend is hidden.}
}
\value{
A ggplot2 object.
}
\description{
build_top_metaplot() builds a vertical stacked bar plot displaying the
frequency of each haplotype combination, broken down by each categorical
metadata variable provided. Makes use of the $Indfile information from a
haplotype object. This is an in internal function called by crosshap_viz(),
though can be called separately to build a stand-alone plot
}
\examples{
build_top_metaplot(HapObject, epsilon = 0.6, hide_labels = FALSE)

}
