% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot_halfeyeplot.R
\name{build_bot_halfeyeplot}
\alias{build_bot_halfeyeplot}
\title{Bot hap-pheno raincloud plot}
\usage{
build_bot_halfeyeplot(
  HapObject,
  epsilon,
  hide_labels = TRUE,
  isolate_group = NA
)
}
\arguments{
\item{HapObject}{Haplotype object created by run_haplotyping().}

\item{epsilon}{Epsilon to visualize haplotyping results for.}

\item{hide_labels}{If TRUE, legend is hidden.}

\item{isolate_group}{If a Metadata group is provided, all other Metadata
groups will be masked from the plot. NOTE: it does change the summary tables
or marker group phenotype scores.}
}
\value{
A ggplot2 object.
}
\description{
build_bot_halfeyeplot() builds a vertical plot displaying the
phenotypic scores for each individual, grouped by haplotype, coloured by
metadata variable. Metadata groups can be isolated using the isolate_groups
argument. Makes use of the $Indfile information from haplotype
object. It is an internal function called by crosshap_viz(), though can be
called separately to build a stand-alone plot.
}
\examples{

build_bot_halfeyeplot(HapObject, epsilon = 0.6, hide_labels = FALSE)

}
