% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/various.R
\name{heaviside}
\alias{heaviside}
\title{Heaviside function (step function)}
\usage{
heaviside(x, x0 = 0)
}
\arguments{
\item{x}{A vector of real numbers.}

\item{x0}{A real number. The x value at which the function step occurs.}
}
\value{
One of the two numbers 0 or 1.
}
\description{
Heaviside function (step function)
}
\examples{
x <- seq(-3,5,length=1000)
x0 <- 1
y <- heaviside(x,x0)
plot(x,y,type="l")
# Step up and step down
x1 <- seq(-3,5,length=1000)
x10 <- 1
y1 <- heaviside(x1,x10)
x2 <- seq(1,9,length=1000)
x20 <- 5
y2 <- heaviside(x2,x20)
y2 <- 1-y2
plot(x1,y1,type="l",xlim=c(-3,9),xlab="x",ylab="y")
points(x2,y2,type="l")
}
