% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cron_rm.R
\name{cron_rm}
\alias{cron_rm}
\title{Remove a cronjob}
\usage{
cron_rm(id, dry_run = FALSE, user = "", ask = TRUE)
}
\arguments{
\item{id}{A set of ids, partially matched from the beginning, 
we wish to remove. We only remove the id if it is uniquely 
matched in the file.}

\item{dry_run}{Boolean; if \code{TRUE} we do not submit the cron job; 
instead we return the parsed text that would be submitted as a cron job.}

\item{user}{The user whose crontab we will be modifying.}

\item{ask}{Boolean; show prompt asking for validation}
}
\description{
Use this command to remove a cron job added by \code{cron_add}.
}
\examples{
\dontshow{if(interactive())
\{
}
f   <- system.file(package = "cronR", "extdata", "helloworld.R")
cmd <- cron_rscript(f)
cron_add(command = cmd, frequency = 'minutely', id = 'test1', description = 'My process 1')
cron_njobs()
cron_ls()
cron_rm(id = "test1")
cron_njobs()
cron_ls()

\dontshow{
\}
}
}
