% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataParts-class}
\alias{DataParts-class}
\alias{.DataParts}
\alias{DataParts}
\alias{.DefaultDataParts}
\title{\code{DataParts}}
\usage{
DataParts(part = integer(), nextPart = 1L, part1Ladder = numeric(), ...)

.DefaultDataParts()
}
\arguments{
\item{part}{(\code{integer})\cr which part does each of the patients belong to?}

\item{nextPart}{(\code{count})\cr what is the part for the next cohort (1 or 2)?}

\item{part1Ladder}{(\code{numeric})\cr what is the escalation ladder for part 1?
This shall be an ordered subset of the \code{doseGrid}.}

\item{...}{parameters passed to \code{\link[=Data]{Data()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{DataParts}} is a class for the data with two study parts.
It inherits from \code{\link{Data}} and it contains additional information
on the two study parts.
}
\section{Slots}{

\describe{
\item{\code{part}}{(\code{integer})\cr which part does each of the patients belong to?}

\item{\code{nextPart}}{(\code{count})\cr what is the part for the next cohort (1 or 2)?}

\item{\code{part1Ladder}}{(\code{numeric})\cr what is the escalation ladder for
part 1? This shall be an ordered subset of the \code{doseGrid}.}
}}

\note{
Typically, end users will not use the \code{.DefaultDataParts()} function.
}
\examples{
my_data <- DataParts(
  x = c(0.1, 0.5, 1.5),
  y = c(0, 0, 0),
  ID = 1:3,
  cohort = 1:3,
  doseGrid = c(0.1, 0.5, 1.5, 3, 6, seq(from = 10, to = 80, by = 2)),
  part = c(1L, 1L, 1L),
  nextPart = 1L,
  part1Ladder = c(0.1, 0.5, 1.5, 3, 6, 10)
)
my_data
}
