% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-methods.R
\docType{methods}
\name{maxDose}
\alias{maxDose}
\alias{maxDose,IncrementsRelative,Data-method}
\alias{maxDose,IncrementsRelativeDLT,Data-method}
\alias{maxDose,IncrementsRelativeParts,DataParts-method}
\title{Determine the maximum possible next dose}
\usage{
maxDose(increments, data, ...)

\S4method{maxDose}{IncrementsRelative,Data}(increments, data, ...)

\S4method{maxDose}{IncrementsRelativeParts,DataParts}(increments, data, ...)

\S4method{maxDose}{IncrementsRelativeDLT,Data}(increments, data, ...)
}
\arguments{
\item{increments}{The rule, an object of class
\code{\linkS4class{Increments}}}

\item{data}{The data input, an object of class \code{\linkS4class{Data}}}

\item{\dots}{further arguments}
}
\value{
the maximum possible next dose
}
\description{
Determine the upper limit of the next dose based on the increments rule.
}
\details{
This function outputs the maximum possible next dose, based on the
corresponding rule \code{increments} and the \code{data}.
}
\section{Methods (by class)}{
\itemize{
\item \code{increments = IncrementsRelative,data = Data}: Determine the maximum possible next dose based on
relative increments

\item \code{increments = IncrementsRelativeParts,data = DataParts}: Determine the maximum possible next dose based on
relative increments and part 1 and 2

\item \code{increments = IncrementsRelativeDLT,data = Data}: Determine the maximum possible next dose based on
relative increments determined by DLTs so far
}}
\examples{

# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 8, 8, 8),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6, 8,
                 seq(from=10, to=80, by=2)))


# In this example we define a rule for dose increments which would allow:
#   - doubling the dose if the last dose was below 20
#   - only increasing the dose by 1.33 if the last dose was equal or above 20
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))

# Based on the rule above, we then calculate the maximum dose allowed
nextMaxDose <- maxDose(myIncrements,
                       data=data)


# create an object of class 'DataParts'
myData <- DataParts(x=c(0.1,0.5,1.5),
                    y=c(0,0,0),
                    doseGrid=c(0.1,0.5,1.5,3,6,
                               seq(from=10,to=80,by=2)),
                    part=c(1L,1L,1L),
                    nextPart=1L,
                    part1Ladder=c(0.1,0.5,1.5,3,6,10))


myIncrements <- IncrementsRelativeParts(dltStart=0,
                                        cleanStart=1)

nextMaxDose <- maxDose(myIncrements,
                       data=myData)


# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))


# In this example we define a rule for dose increments which would allow:
#   - doubling the dose if no DLTs were yet observed
#   - only increasing the dose by 1.33 if 1 or 2 DLTs were already observed
#   - only increasing the dose by 1.2 if at least 3 DLTs were already observed
myIncrements <- IncrementsRelativeDLT(DLTintervals = c(0, 1, 3),
                                      increments = c(1, 0.33, 0.2))

# Based on the rule above, we then calculate the maximum dose allowed
nextMaxDose <- maxDose(myIncrements,
                       data=data)

}
\keyword{methods}

