% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rules-methods.R
\docType{methods}
\name{nextBest}
\alias{nextBest}
\alias{nextBest,NextBestDualEndpoint,numeric,Samples,DualEndpoint,Data-method}
\alias{nextBest,NextBestMTD,numeric,Samples,Model,Data-method}
\alias{nextBest,NextBestMaxGain,numeric,missing,ModelTox,DataDual-method}
\alias{nextBest,NextBestMaxGainSamples,numeric,Samples,ModelTox,DataDual-method}
\alias{nextBest,NextBestNCRM,numeric,Samples,Model,Data-method}
\alias{nextBest,NextBestNCRM,numeric,Samples,Model,DataParts-method}
\alias{nextBest,NextBestTD,numeric,missing,LogisticIndepBeta,Data-method}
\alias{nextBest,NextBestTDsamples,numeric,Samples,LogisticIndepBeta,Data-method}
\alias{nextBest,NextBestThreePlusThree,missing,missing,missing,Data-method}
\title{Find the next best dose}
\usage{
nextBest(nextBest, doselimit, samples, model, data, ...)

\S4method{nextBest}{NextBestMTD,numeric,Samples,Model,Data}(nextBest, doselimit,
  samples, model, data, ...)

\S4method{nextBest}{NextBestNCRM,numeric,Samples,Model,Data}(nextBest,
  doselimit, samples, model, data, ...)

\S4method{nextBest}{NextBestNCRM,numeric,Samples,Model,DataParts}(nextBest,
  doselimit, samples, model, data, ...)


  \S4method{nextBest}{NextBestThreePlusThree,missing,missing,missing,Data}(nextBest,
  doselimit, samples, model, data, ...)


  \S4method{nextBest}{NextBestDualEndpoint,numeric,Samples,DualEndpoint,Data}(nextBest,
  doselimit, samples, model, data, ...)


  \S4method{nextBest}{NextBestTDsamples,numeric,Samples,LogisticIndepBeta,Data}(nextBest,
  doselimit, samples, model, data, ...)


  \S4method{nextBest}{NextBestTD,numeric,missing,LogisticIndepBeta,Data}(nextBest,
  doselimit, samples, model, data, ...)


  \S4method{nextBest}{NextBestMaxGain,numeric,missing,ModelTox,DataDual}(nextBest,
  doselimit, model, data, Effmodel, ...)


  \S4method{nextBest}{NextBestMaxGainSamples,numeric,Samples,ModelTox,DataDual}(nextBest,
  doselimit, samples, model, data, Effmodel, Effsamples, ...)
}
\arguments{
\item{nextBest}{The rule, an object of class \code{\linkS4class{NextBest}}}

\item{doselimit}{The maximum allowed next dose. If this is an empty (length
0) vector, then no dose limit will be applied in the course of dose
recommendation calculation, and a corresponding warning is given.}

\item{samples}{the \code{\linkS4class{Samples}} object}

\item{model}{The model input, an object of class \code{\linkS4class{Model}}}

\item{data}{The data input, an object of class \code{\linkS4class{Data}}}

\item{Effmodel}{the efficacy model of \code{\linkS4class{ModelEff}} class object}

\item{Effsamples}{the efficacy samples of \code{\linkS4class{Samples}} class object}

\item{\dots}{possible additional arguments without method dispatch}
}
\value{
a list with the next best dose (element \code{value})
on the grid defined in \code{data}, and a plot depicting this recommendation
(element \code{plot})
}
\description{
Compute the recommended next best dose.
}
\details{
This function outputs the next best dose recommendation based on the
corresponding rule \code{nextBest}, the posterior \code{samples} from the
\code{model} and the underlying \code{data}.
}
\section{Methods (by class)}{
\itemize{
\item \code{nextBest = NextBestMTD,doselimit = numeric,samples = Samples,model = Model,data = Data}: Find the next best dose based on the MTD rule

\item \code{nextBest = NextBestNCRM,doselimit = numeric,samples = Samples,model = Model,data = Data}: Find the next best dose based on the NCRM method

\item \code{nextBest = NextBestNCRM,doselimit = numeric,samples = Samples,model = Model,data = DataParts}: Find the next best dose based on the NCRM method when
two parts trial is used - todo: need an example here for DataParts

\item \code{nextBest = NextBestThreePlusThree,doselimit = missing,samples = missing,model = missing,data = Data}: Find the next best dose based on the 3+3 method

\item \code{nextBest = NextBestDualEndpoint,doselimit = numeric,samples = Samples,model = DualEndpoint,data = Data}: Find the next best dose based on the dual endpoint
model

\item \code{nextBest = NextBestTDsamples,doselimit = numeric,samples = Samples,model = LogisticIndepBeta,data = Data}: Find the next best dose based on the 'NextBestTDsamples'
class rule. This a method based only on the DLE responses and for
\code{\linkS4class{LogisticIndepBeta}} model class object involving DLE samples

\item \code{nextBest = NextBestTD,doselimit = numeric,samples = missing,model = LogisticIndepBeta,data = Data}: Find the next best dose based on the 'NextBestTD'
class rule. This a method based only on the DLE responses and for
\code{\linkS4class{LogisticIndepBeta}} model class object without DLE samples

\item \code{nextBest = NextBestMaxGain,doselimit = numeric,samples = missing,model = ModelTox,data = DataDual}: for slots \code{nextBest},\code{doselimit} and \code{data}. This is
a function to find the next best dose based on the 'NextBestMaxGain'
class rule. This a method based on the DLE responses and efficacy responses without DLE and
efficacy samples.

\item \code{nextBest = NextBestMaxGainSamples,doselimit = numeric,samples = Samples,model = ModelTox,data = DataDual}: for slots \code{nextBest},\code{doselimit} and \code{data}. This is
a function to find the next best dose based on the 'NextBestMaxGainSamples'
class rule. This a method based on the DLE responses and efficacy responses with DLE and
efficacy samples. Effmodel must be of class \code{\linkS4class{Effloglog}} or
\code{\linkS4class{EffFlexi}}.
}}
\examples{

# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestMTD'
mtdNextBest <- NextBestMTD(target=0.33,
                           derive=
                             function(mtdSamples){
                               quantile(mtdSamples, probs=0.25)
                             })

# Calculate the next best dose
doseRecommendation <- nextBest(mtdNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)

# Create the data
data <- Data(x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y=c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort=c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 6,
                 seq(from=10, to=80, by=2)))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, model=model, data=data)


# create an object of class 'DataParts'
data <- DataParts(x=c(0.1,0.5,1.5),
                    y=c(0,0,0),
                    doseGrid=c(0.1,0.5,1.5,3,6,
                               seq(from=10,to=80,by=2)),
                    part=c(1L,1L,1L),
                    nextPart=1L,
                    part1Ladder=c(0.1,0.5,1.5,3,6,10))

# Initialize the CRM model used to model the data
model <- LogisticLogNormal(mean=c(-0.85, 1),
                           cov=
                             matrix(c(1, -0.5, -0.5, 1),
                                    nrow=2),
                           refDose=56)

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=2000)
set.seed(94)
samples <- mcmc(data, model, options)

myIncrements <- IncrementsRelativeParts(dltStart=0,
                                        cleanStart=1)
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# based on the class 'NextBestNCRM'
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples, 
                               model=model, 
                               data=data)


# Create the data
data <- Data(x=c(5, 5, 5, 10, 10, 10),
             y=c(0, 0, 0, 0, 1, 0),
             cohort=c(0, 0, 0, 1, 1, 1),
             doseGrid=
               c(0.1, 0.5, 1.5, 3, 5,
                 seq(from=10, to=80, by=2)))


# The rule to select the next best dose will be based on the 3+3 method
myNextBest <- NextBestThreePlusThree()

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               data=data)


# Create the data
data <- DataDual(
  x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10,
      20, 20, 20, 40, 40, 40, 50, 50, 50),
  y=c(0, 0, 0, 0, 0, 0, 1, 0,
      0, 1, 1, 0, 0, 1, 0, 1, 1),
  w=c(0.31, 0.42, 0.59, 0.45, 0.6, 0.7, 0.55, 0.6,
      0.52, 0.54, 0.56, 0.43, 0.41, 0.39, 0.34, 0.38, 0.21),
  doseGrid=c(0.1, 0.5, 1.5, 3, 6,
             seq(from=10, to=80, by=2)))

# Initialize the Dual-Endpoint model (in this case RW1)
model <- DualEndpointRW(mu = c(0, 1),
                        Sigma = matrix(c(1, 0, 0, 1), nrow=2),
                        sigma2betaW = 0.01,
                        sigma2W = c(a=0.1, b=0.1),
                        rho = c(a=1, b=1),
                        smooth = "RW1")

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=500)
set.seed(94)
samples <- mcmc(data, model, options)

# Define the rule for dose increments and calculate the maximum dose allowed
myIncrements <- IncrementsRelative(intervals=c(0, 20),
                                   increments=c(1, 0.33))
nextMaxDose <- maxDose(myIncrements,
                       data=data)

# Define the rule which will be used to select the next best dose
# In this case target a dose achieving at least 0.9 of maximum biomarker level (efficacy)
# and with a probability below 0.25 that prob(DLT)>0.35 (safety)
myNextBest <- NextBestDualEndpoint(target=c(0.9, 1),
                                   overdose=c(0.35, 1),
                                   maxOverdoseProb=0.25)

# Calculate the next best dose
doseRecommendation <- nextBest(myNextBest,
                               doselimit=nextMaxDose,
                               samples=samples,
                               model=model,
                               data=data)

## we need a data object with doses >= 1:
data<-Data(x=c(25,50,50,75,150,200,225,300),
           y=c(0,0,0,0,1,1,1,1),
           doseGrid=seq(from=25,to=300,by=25))
##The 'nextBest' method using NextBestTDsamples' rules class object
## That is dose-esclation procedure using the 'logisticIndepBeta' DLE model involving DLE samples
## model must be of 'LogisticIndepBeta' class
model<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)

##Define the options for MCMC
options <- McmcOptions(burnin=100,step=2,samples=1000)
##Then genreate the samples
samples <- mcmc(data, model, options)

##target probabilities of the occurrence of a DLE during trial and at the end of trial are 
## defined as 0.35 and 0.3, respectively
##Specified in 'derive' such that the 30\% posterior quantile of the TD35 and TD30 samples 
## will be used as TD35 and TD30 estimates
tdNextBest<-NextBestTDsamples(targetDuringTrial=0.35,targetEndOfTrial=0.3,
                              derive=function(TDsamples){quantile(TDsamples,probs=0.3)})

##doselimit is the maximum allowable dose level to be given to subjects
RecommendDose<-nextBest(tdNextBest,doselimit=max(data@doseGrid),samples=samples,
                        model=model,data=data)
## we need a data object with doses >= 1:
data<-Data(x=c(25,50,50,75,150,200,225,300),
           y=c(0,0,0,0,1,1,1,1),
           doseGrid=seq(from=25,to=300,by=25))
##The 'nextBest' method using NextBestTD' rules class object
## That is dose-esclation procedure using the 'logisticIndepBeta' DLE model involving DLE samples
## model must be of 'LogisticIndepBeta' class
model<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
##target probabilities of the occurrence of a DLE during trial and at the end of trial 
## are defined as 0.35 and 0.3, respectively
tdNextBest<-NextBestTD(targetDuringTrial=0.35,targetEndOfTrial=0.3)

##doselimit is the maximum allowable dose level to be given to subjects
RecommendDose<- nextBest(tdNextBest,
              doselimit=max(data@doseGrid),
              model=model,
              data=data)
## we need a data object with doses >= 1:
data <-DataDual(x=c(25,50,25,50,75,300,250,150),
               y=c(0,0,0,0,0,1,1,0),
               w=c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
               doseGrid=seq(25,300,25))

##The 'nextBest' method using NextBestMaxGain' rules class object
## using the 'ModelTox' class DLE model 
## DLEmodel e.g 'LogisticIndepBeta' class
DLEmodel<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)

## using the 'ModelEff' class efficacy model 
## Effmodel e.g 'Effloglog' class
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),nu=c(a=1,b=0.025),data=data)

##target probabilities of the occurrence of a DLE during trial and at the
## end of trial are defined as
## 0.35 and 0.3, respectively
mynextbest<-NextBestMaxGain(DLEDuringTrialtarget=0.35,DLEEndOfTrialtarget=0.3)

##doselimit is the maximum allowable dose level to be given to subjects
RecommendDose<-nextBest(mynextbest,doselimit=300,model=DLEmodel,Effmodel=Effmodel,data=data)
data <-DataDual(x=c(25,50,25,50,75,300,250,150),
                y=c(0,0,0,0,0,1,1,0),
                w=c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
                doseGrid=seq(25,300,25))
##The 'nextBest' method using NextBestMaxGainSamples' rules class object
## using the 'ModelTox' class DLE model 
## DLEmodel e.g 'LogisticIndepBeta' class
DLEmodel<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)

## using the 'ModelEff' class efficacy model 
## Effmodel e.g 'Effloglog' class
Effmodel<-Effloglog(c(1.223,2.513),c(25,300),nu=c(a=1,b=0.025),data=data)
##DLE and efficacy samples must be of 'Samples' Class
DLEsamples<-mcmc(data,DLEmodel,options)
Effsamples<-mcmc(data,Effmodel,options)

##target probabilities of the occurrence of a DLE during trial and at the end of trial 
## are defined as 0.35 and 0.3, respectively
## Using 30\% posterior quantile of the TD35 and TD30 samples as estimates of TD35 and TD30, 
## function specified in TDderive slot
## Using the 50\% posterior quantile of the Gstar (the dose which gives the maxim gain value) 
## samples as Gstar estimate,function specified in Gstarderive slot 
mynextbest<-NextBestMaxGainSamples(DLEDuringTrialtarget=0.35,
                                   DLEEndOfTrialtarget=0.3,
                                   TDderive=function(TDsamples){
                                     quantile(TDsamples,prob=0.3)},
                                   Gstarderive=function(Gstarsamples){
                                     quantile(Gstarsamples,prob=0.5)})

RecommendDose<-nextBest(mynextbest,doselimit=max(data@doseGrid),samples=DLEsamples,model=DLEmodel,
                        data=data,Effmodel=Effmodel,Effsamples=Effsamples)

## now using the 'EffFlexi' class efficacy model:

##The 'nextBest' method using NextBestMaxGainSamples' rules class object for 'EffFlexi' model class
## using the 'ModelTox' class DLE model 
## DLEmodel e.g 'LogisticIndepBeta' class
Effmodel<- EffFlexi(Eff=c(1.223, 2.513),Effdose=c(25,300),
                    sigma2=c(a=0.1,b=0.1),
                    sigma2betaW=c(a=20,b=50),smooth="RW2",data=data)

##DLE and efficacy samples must be of 'Samples' Class
DLEsamples<-mcmc(data,DLEmodel,options)
Effsamples<-mcmc(data,Effmodel,options)

##target probabilities of the occurrence of a DLE during trial and at the 
## end of trial are defined as 0.35 and 0.3, respectively
## Using 30\% posterior quantile of the TD35 and TD30 samples as estimates of 
## TD35 and TD30, function specified in TDderive slot
## Using the 50\% posterio quantile of the Gstar (the dose which gives the maximum 
## gain value) samples as Gstar estimate,function specified in Gstarderive slot 
mynextbest<-NextBestMaxGainSamples(DLEDuringTrialtarget=0.35,
                                   DLEEndOfTrialtarget=0.3,
                                   TDderive=function(TDsamples){
                                     quantile(TDsamples,prob=0.3)},
                                   Gstarderive=function(Gstarsamples){
                                     quantile(Gstarsamples,prob=0.5)})

RecommendDose<-nextBest(mynextbest,doselimit=max(data@doseGrid),samples=DLEsamples,
                        model=DLEmodel,
                        data=data,Effmodel=Effmodel,Effsamples=Effsamples)

}
\keyword{methods}

