% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criticalpath.R
\docType{package}
\name{criticalpath}
\alias{criticalpath}
\title{criticalpath: Critical Path Method R Implementation}
\description{
\code{criticalpath} package is an R implementation of the
Critical Path Method (CPM). CPM is a method used to estimate
the minimum project duration and  determine the amount of scheduling
flexibility
on the logical network paths within the schedule model. The flexibility is in
terms of early start, early finish, late start, late finish, total float and
free float. Beside, it permits to quantify the complexity of network diagram
through the analysis of topological indicators. Finally, it permits to change
the activities duration to perform what-if scenario analysis.
}
\details{
With this package, you can calculate the following CPM parameters:
\itemize{
\item Schedule duration
\item Early start and finish date of each activity
\item Late start and finish date of each activity
\item Critical activities
\item Critical path
\item Total float and free float
\item Gantt Matrix
\item What-if scenario analysis
\item Topological indicators
}
}
\references{
Csardi, G. & Nepusz, T. (2005).
The Igraph Software Package for Complex Network Research.
\emph{InterJournal}. Complex Systems. 1695.

Project Management Institute (2017)
\strong{A Guide to the Project Management Body of Knowledge (PMBOK Guide)}.
Sixth Edition.

Project Management Institute (2017)
\strong{PMI Lexicon of Project Management Terms:} Version 3.2.

Vanhoucke, M. (2009) \strong{Measuring Time}:
Improving Project Performance Using Earned Value Management.
Springer-Verlag US.

Vanhoucke, M. (2013) \strong{Project Management with Dynamic Scheduling}:
Baseline Scheduling, Risk Analysis and Project Control.
Springer-Verlag Berlin Heidelberg.

Vanhoucke, M. (2014) \strong{Integrated Project Management and Control}:
First Comes the Theory, then the Practice.
Springer International Publishing Switzerland.
}
\seealso{
On vignette package there are more information with examples about:
\itemize{
\item How to create a schedule:
\itemize{
\item Create a new schedule without any information.
\itemize{
\item \code{\link[=sch_new]{sch_new()}}
}
\item Add activities and relations together to an schedule.
\itemize{
\item \code{\link[=sch_add_activities]{sch_add_activities()}}
\item \code{\link[=sch_add_relations]{sch_add_relations()}}
}
\item Add activities to a schedule.
\itemize{
\item \code{\link[=sch_add_activity]{sch_add_activity()}}
}
\item Add relations to a schedule.
\itemize{
\item \code{\link[=sch_add_relation]{sch_add_relation()}}
}
}
\item How to get schedule information:
\itemize{
\item Title
\itemize{
\item \code{\link[=sch_title]{sch_title()}}
}
\item Reference
\itemize{
\item \code{\link[=sch_reference]{sch_reference()}}
}
\item Duration
\itemize{
\item \code{\link[=sch_duration]{sch_duration()}}
}
}
\item How to get activities properties:
\itemize{
\item Activity Properties.
\itemize{
\item \code{\link[=sch_activities]{sch_activities()}}
\item \code{\link[=sch_get_activity]{sch_get_activity()}}
}
\item Gantt Matrix.
\itemize{
\item \code{\link[=sch_gantt_matrix]{sch_gantt_matrix()}}
\item \code{\link[=sch_xy_gantt_matrix]{sch_xy_gantt_matrix()}}
}
}
\item How to change activities duration:
\itemize{
\item Change Activities Duration.
\itemize{
\item \code{\link[=sch_change_activities_duration]{sch_change_activities_duration()}}
}
}
\item How to get relations properties:
\itemize{
\item Relation Properties
\itemize{
\item \code{\link[=sch_relations]{sch_relations()}}
}
\item Successors and Predecessors.
\itemize{
\item \code{\link[=sch_all_successors]{sch_all_successors()}}
\item \code{\link[=sch_successors]{sch_successors()}}
\item \code{\link[=sch_all_predecessors]{sch_all_predecessors()}}
\item \code{\link[=sch_predecessors]{sch_predecessors()}}
}
}
\item How to get topological properties:
\itemize{
\item Topological Indicators.
\itemize{
\item \code{\link[=sch_topoi_sp]{sch_topoi_sp()}}
\item \code{\link[=sch_topoi_ad]{sch_topoi_ad()}}
\item \code{\link[=sch_topoi_la]{sch_topoi_la()}}
\item \code{\link[=sch_topoi_tf]{sch_topoi_tf()}}
}
}
}
}
\author{
Rubens Jose Rosa (\email{rubens@rubensjoserosa.com}),
Marcos dos Santos (\email{marcosdossantos@ime.eb.br}),
Thiago Marques (\email{profestathimarques@gmail.com})
}
