% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schedule.R
\name{Schedule}
\alias{Schedule}
\alias{schedule}
\title{R6 Class Representing a Schedule}
\description{
This class is a representation of Precedence Diagramming Method (PDM).
PDM is a technique used for constructing a schedule model in which activities
are represented by nodes and are graphically linked by one or more logical
relationships to show the sequence in which the activities are to be performed.

A schedule has activities and relations data-frames. With this class,
it is possible to apply critical path method
}
\examples{
## ------------------------------------------------
## Property `Schedule$title`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"
schedule$title

## ------------------------------------------------
## Property `Schedule$reference`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"
schedule$reference

## ------------------------------------------------
## Property `Schedule$duration`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)
schedule$duration

## ------------------------------------------------
## Property `Schedule$has_any_activity`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$has_any_activity  # FALSE

# Add one activity.
schedule$add_activity( 1, "a1" , 0)
schedule$has_any_activity  # TRUE

## ------------------------------------------------
## Property `Schedule$nr_activities`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$nr_activities     # 0

# Add one activity.
schedule$add_activity( 1, "a1" , 0)
schedule$nr_activities     # 1

## ------------------------------------------------
## Property `Schedule$activities`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(6))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(6))
schedule$add_act_rel(  6, "a6" , 5)
schedule$activities

## ------------------------------------------------
## Property `Schedule$get_activity(id)`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(6))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(6))
schedule$add_act_rel(  6, "a6" , 5)
schedule$get_activity(4)
schedule$get_activity(6)

## ------------------------------------------------
## Property `Schedule$has_any_relation`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$has_any_relation   #FALSE

# Add activities and relations to it.
schedule$add_act_rel(1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(2, "a2" , 4)
schedule$add_act_rel(3, "a3" , 9)
schedule$add_act_rel(4, "a4" , 1)
schedule$has_any_relation   # TRUE

## ------------------------------------------------
## Property `Schedule$nr_relations`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
schedule$nr_relations   # 0

# Add activities and relations to it.
schedule$add_act_rel(1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(2, "a2" , 4)
schedule$add_act_rel(3, "a3" , 9)
schedule$add_act_rel(4, "a4" , 1)
schedule$nr_relations   # 3

## ------------------------------------------------
## Property `Schedule$relations`
## ------------------------------------------------
# Create a schedule
schedule <- Schedule$new()
# Add activities and relations to it.
schedule$add_act_rel(1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(2, "a2" , 4)
schedule$add_act_rel(3, "a3" , 9)
schedule$add_act_rel(4, "a4" , 1)
schedule$relations


## ------------------------------------------------
## Method `Schedule$new`
## ------------------------------------------------

# An empty schedule.
schedule <- Schedule$new()
schedule$duration
schedule$activities
schedule$relations

# A schedule with activities and relations.
activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,2,2,4,3,3,3,2,1,1,2,1,1,1,1,2,1)
)

relations <- data.frame(
  from = c(1, 1, 2, 2, 2, 3, 3, 3,  3,  4,  5,  6,
           7,  8,  9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15),
  to   = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 11,
           12, 13, 14, 15, 16, 17, 16, 17, 16, 17, 16, 17, 16, 17)
)
schedule <- Schedule$new(activities, relations)
schedule$title <- "Project 1: Cost Information System"
schedule$reference <- "VANHOUCKE, Mario.
Integrated project management and control:
  first comes the theory, then the practice.
  Gent: Springer, 2014, p. 6"
schedule$duration
schedule$activities
schedule$relations


## ------------------------------------------------
## Method `Schedule$add_activity`
## ------------------------------------------------

schedule <- Schedule$new()
schedule$add_activity(1, "Task 1", 5)
schedule$add_activity(2, "Task 2", 6)
schedule$add_activity(3, "Task 3", 8)
schedule$add_activity(4, "Task 4", 6)
schedule$add_activity(5, "Task 5", 9)
schedule$add_activity(6, "Task 6", 3)
schedule$add_activity(7, "Task 7", 4)
schedule$duration
schedule$activities

## ------------------------------------------------
## Method `Schedule$add_activities`
## ------------------------------------------------

activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,2,2,4,3,3,3,2,1,1,2,1,1,1,1,2,1)
)
schedule <- Schedule$new()
schedule$add_activities(activities)
schedule$duration
schedule$activities

## ------------------------------------------------
## Method `Schedule$get_activity`
## ------------------------------------------------

x <- runif(1)

## ------------------------------------------------
## Method `Schedule$add_relation`
## ------------------------------------------------

# First, create an empty schedule
schedule <- Schedule$new()
schedule$title <- "Project 3: Old Carriage House Renovation"
schedule$reference <-
  "VANHOUCKE, Mario. Integrated project management and control:
  first comes the theory, then the practice. Gent: Springer, 2014, p. 11"

# Second, add activities to it
schedule$add_activity(1, "a1" , 2)
schedule$add_activity(2, "a2" , 2)
schedule$add_activity(3, "a3" , 4)
schedule$add_activity(4, "a4" , 3)
schedule$add_activity(5, "a5" , 4)
schedule$add_activity(6, "a6" , 1)
schedule$add_activity(7, "a7" , 1)
schedule$add_activity(8, "a8" , 1)
schedule$add_activity(9, "a9" , 1)
schedule$add_activity(10, "a10", 1)
schedule$add_activity(11, "a11", 3)
schedule$add_activity(12, "a12", 2)
schedule$add_activity(13, "a13", 1)
schedule$add_activity(14, "a14", 1)
schedule$add_activity(15, "a15", 2)
schedule$add_activity(16, "a16", 1)
schedule$add_activity(17, "a17", 1)

# Finally, add relations to it
schedule$add_relation( 1, 2)
schedule$add_relation( 2, 3)
schedule$add_relation( 3, 4)
schedule$add_relation( 4, 5)
schedule$add_relation( 5, 6)
schedule$add_relation( 6, 7)
schedule$add_relation( 6, 8)
schedule$add_relation( 6, 9)
schedule$add_relation( 7, 10)
schedule$add_relation( 8, 10)
schedule$add_relation( 9, 10)
schedule$add_relation( 10, 11)
schedule$add_relation( 10, 13)
schedule$add_relation( 11, 12)
schedule$add_relation( 12, 15)
schedule$add_relation( 13, 14)
schedule$add_relation( 14, 15)
schedule$add_relation( 15, 16)
schedule$add_relation( 16, 17)
schedule$duration
schedule$activities
schedule$relations

## ------------------------------------------------
## Method `Schedule$add_relations`
## ------------------------------------------------

# A schedule with activities and relations.
activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,2,2,4,3,3,3,2,1,1,2,1,1,1,1,2,1)
)

relations <- data.frame(
  from = c(1, 1, 2, 2, 2, 3, 3, 3,  3,  4,  5,  6,
           7,  8,  9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15),
  to   = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 11,
           12, 13, 14, 15, 16, 17, 16, 17, 16, 17, 16, 17, 16, 17)
)
schedule <- Schedule$new(activities)
schedule$title <- "Project 1: Cost Information System"
schedule$reference <- "VANHOUCKE, Mario.
Integrated project management and control:
  first comes the theory, then the practice.
  Gent: Springer, 2014, p. 6"
schedule$relations # Empty

schedule$add_relations(relations)
schedule$relations # Not empty


## ------------------------------------------------
## Method `Schedule$add_act_rel`
## ------------------------------------------------

# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)
schedule$duration
schedule$activities
schedule$relations

## ------------------------------------------------
## Method `Schedule$print`
## ------------------------------------------------

schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"
schedule

## ------------------------------------------------
## Method `Schedule$all_successors`
## ------------------------------------------------


# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  2, "a2" , 4, c(5, 12))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$all_successors(2) # 5, 9, 12
schedule$all_successors(7) # 8, 11, 12
schedule$all_successors(10) # 12


## ------------------------------------------------
## Method `Schedule$all_predecessors`
## ------------------------------------------------


# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  2, "a2" , 4, c(5, 12))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$all_predecessors(2) # nothing
schedule$all_predecessors(7) # 6, 4
schedule$all_predecessors(10) # 3


## ------------------------------------------------
## Method `Schedule$is_redundant`
## ------------------------------------------------


# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  2, "a2" , 4, c(5, 12))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$is_redundant(2, 5)  #FALSE
schedule$is_redundant(2, 12) #TRUE


## ------------------------------------------------
## Method `Schedule$change_durations`
## ------------------------------------------------

activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,1,3,2, 2,2,2,1, 4,5,3,3, 4,5,1,5,2)
)

relations <- data.frame(
  from = c(1, 2, 3, 3, 4, 5, 6, 7, 8,  8,  8,
    8,  8,  9, 10, 11, 12, 13, 13, 14, 14, 15, 15),
  to   = c(2, 3, 4, 6, 5, 8, 7, 8, 9, 10, 11,
   12, 13, 14, 14, 14, 14, 14, 15, 16, 17, 16, 17)
)

schedule <- Schedule$new(activities, relations)
schedule$title <- "Project 2: Patient Transport System"
schedule$reference <-
  "VANHOUCKE, Mario. Integrated project management and control:
  first comes the theory, then the practice. Gent: Springer, 2014, p. 9"
#Project duration
schedule$duration # 25
#Activities duration
schedule$activities$duration

# Now, change activities duration
new_durations <- c(1,2,5, 4,3, 2,1, 5, 3,5,5,3,4, 2,1, 2,4)
schedule$change_durations(new_durations)

#Project duration
schedule$duration # 31
#Activities duration
schedule$activities$duration


## ------------------------------------------------
## Method `Schedule$gantt_matrix`
## ------------------------------------------------

activities <- data.frame(
  id        = c( 1,   2,   3,   4 ),
  name      = c("A", "B", "C", "D"),
  duration  = c( 2,   3,   1,   2 )
)
relations <- data.frame(
  from = c(1, 2, 4, 4),
  to   = c(3, 3, 1, 2)
)
schedule <- Schedule$new(activities, relations)
gantt <- schedule$gantt_matrix()
gantt
# What is the effort by time period?
colSums(gantt) # 1 1 2 2 1 1
# What is the duration by activities?
rowSums(gantt) # 2 3 1 2
# what is the S curve
cumsum(colSums(gantt))
plot(cumsum(colSums(gantt)), type="l", lwd=3)


## ------------------------------------------------
## Method `Schedule$xy_gantt_matrix`
## ------------------------------------------------

activities <- data.frame(
  id        = c( 1,   2,   3,   4 ),
  name      = c("A", "B", "C", "D"),
  duration  = c( 2,   3,   1,   2 )
)
relations <- data.frame(
  from = c(1, 2, 4, 4),
  to   = c(3, 3, 1, 2)
)
schedule <- Schedule$new(activities, relations)
gantt <- schedule$gantt_matrix()
xyw <- schedule$xy_gantt_matrix()
xyw
plot(xyw[, 1:2])


## ------------------------------------------------
## Method `Schedule$topoi_sp`
## ------------------------------------------------

# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_sp()


## ------------------------------------------------
## Method `Schedule$topoi_ad`
## ------------------------------------------------

# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_ad()


## ------------------------------------------------
## Method `Schedule$topoi_la`
## ------------------------------------------------

# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_la()


## ------------------------------------------------
## Method `Schedule$topoi_tf`
## ------------------------------------------------

# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_tf()

}
\references{
Csardi, G. & Nepusz, T. (2005).
The Igraph Software Package for Complex Network Research.
\emph{InterJournal}. Complex Systems. 1695.

Project Management Institute (2017)
\strong{A Guide to the Project Management Body of Knowledge (PMBOK Guide)}.
Sixth Edition.

Project Management Institute (2017)
\strong{PMI Lexicon of Project Management Terms:} Version 3.2.

Vanhoucke, M. (2009) \strong{Measuring Time}:
Improving Project Performance Using Earned Value Management.
Springer-Verlag US.

Vanhoucke, M. (2013) \strong{Project Management with Dynamic Scheduling}:
Baseline Scheduling, Risk Analysis and Project Control.
Springer-Verlag Berlin Heidelberg.

Vanhoucke, M. (2014) \strong{Integrated Project Management and Control}:
First Comes the Theory, then the Practice.
Springer International Publishing Switzerland.
}
\seealso{
On vignette package there is more information with examples about:
\itemize{
\item Critical Path Method Package \link{criticalpath}.
\item How to create a schedule:
\itemize{
\item Add activities and relations together to an schedule.
\item Add activities to a schedule.
\item Add relations to a schedule.
\item Create a schedule object from data frames.
}
\item How to get schedule information:
\itemize{
\item Title, Reference and Schedule Duration.
}
\item How to get activities properties:
\itemize{
\item Activity Properties.
\item Gantt Matrix.
}
\item How to change activities duration:
\itemize{
\item Change Activities Duration.
}
\item How to get relations properties:
\itemize{
\item Relation Properties
\item Successors and Predecessors.
}
\item How to get topological properties:
\itemize{
\item Topological Indicators.
}
}
}
\author{
Rubens Jose Rosa (\email{rubens@rubensjoserosa.com}),
Marcos dos Santos (\email{marcosdossantos@ime.eb.br}),
Thiago Marques (\email{profestathimarques@gmail.com})
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{title}}{A project title for identification. It depends on
user of the class. Its use are:
\itemize{
\item \code{Sechedule$title <- "A title"}
\itemize{
\item sets a title for a project.
}
\item \code{Sechedule$title}
\itemize{
\item gets the title of the project.
}
}}

\item{\code{reference}}{A reference from project origin, for example, a book, a paper, a corporation,
or nothing. Its uses are:
\itemize{
\item \code{Sechedule$reference <- "A reference"}
\itemize{
\item sets a reference for a project.
}
\item \code{Sechedule$title}
\itemize{
\item gets the reference of the project.
}
}}

\item{\code{has_any_activity}}{A logical value that indicates if the schedule
has any activity. A TRUE value means that the schedule has some
activity; a FALSE, means that the schedule is empty.
\itemize{
\item Usage: \code{Schedule$has_any_activity}
}}

\item{\code{nr_activities}}{Number of activities in a schedule as an integer value.
\itemize{
\item Usage: \code{Schedule$nr_activities}
}}

\item{\code{activities}}{Return a data frame with all activities of a schedule
in an activity id order. This is the main information calculated by CPM.
The data frame is formed by following structure:
\itemize{
\item \strong{id:} Activity id.
\item \strong{name:} The name of activity.
\item \strong{duration:} A number that represents the activity's duration.
\item \strong{milestone:} A milestone is an activity with zero duration.
This property indicates if an activity is a milestone or not:
\code{TRUE} indicates it is a milestone; \code{FALSE} indicates it is not.
\item \strong{critical:} A critical activity is one with total float minor or equal
to zero. This property indicates if an activity is critical:
\code{TRUE} indicates it is critical;
\code{FALSE} indicates it is not critical.
\item \strong{ES:} Early Start: is the earliest start period an activity can begin
after its predecessors without violating precedence relation.
\item \strong{EF:} Early Finish: is the early start plus activity duration.
\item \strong{LS:} Late Start: is the late finish minus activity duration.
\item \strong{LF:} Late Finish: is the latest finish an activity can finish
before their successors without violating precedence relation.
\item \strong{total_float:} It is the amount of period an activity can be
delayed without violating the project duration. Its formula is:
LS - ES or LF - EF.
\item \strong{free_float:} It is the amount of period an activity can be
delayed without violating the start time of the successors activities.
\item \strong{progr_level:} Progressive level is the rank of activities counted
from begin. The level of the activities that don't have predecessor is one;
the level of the other activities, is one plus the maximal level of
their predecessor.
\item \strong{regr_level:} Regressive level is the rank of activities counted
from the end. The level of the activities that don't have successor is the
maximal progressive level; the level of the other activities,
is one minus the minimal level of their successor.
\item \strong{topo_float:} It is the difference between progressive level
and regressive level.
\item Usage: \code{Schedule$activities}
}}

\item{\code{has_any_relation}}{A logical value that indicates if the schedule
has any relation. A TRUE value means that the schedule has some
relation; a FALSE, means that the schedule does not have any relation.
\itemize{
\item Usage: \code{Schedule$has_any_relation}
}}

\item{\code{nr_relations}}{Number of relations in a schedule as an integer value.
\itemize{
\item Usage: \code{Schedule$nr_relations}
}}

\item{\code{relations}}{Return a data frame with all relations of a schedule
in topological order. This is the main information calculated by CPM.
The data frame is formed by following structure:
\itemize{
\item \strong{from:} Predecessor activity id from a relation.
\item \strong{to:} Successor activity id from a relation.
\item \strong{type:} The type of relation between activities.
Its value may be: FS, FF, SS, SF.
\item \strong{lag:} The time period between activity predecessor and
activity successor activity
\item \strong{critical:} A critical relation formed by two activity critical:
predecessor and successor.
\code{TRUE} indicates it is critical;
\code{FALSE} indicates it is not critical.
\item \strong{ord:} Indicates de order that the relation was added in the schedule.
\item \strong{i_from:} It is the index of predecessor activity in the
activities data frame.
\item \strong{i_to:} It is the index of successor activity in the
activities data frame.
\item Usage: \code{Schedule$relations}
}}

\item{\code{duration}}{An integer value that indicates the duration of a schedule.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Schedule$new()}}
\item \href{#method-add_activity}{\code{Schedule$add_activity()}}
\item \href{#method-add_activities}{\code{Schedule$add_activities()}}
\item \href{#method-get_activity}{\code{Schedule$get_activity()}}
\item \href{#method-add_relation}{\code{Schedule$add_relation()}}
\item \href{#method-add_relations}{\code{Schedule$add_relations()}}
\item \href{#method-add_act_rel}{\code{Schedule$add_act_rel()}}
\item \href{#method-print}{\code{Schedule$print()}}
\item \href{#method-all_successors}{\code{Schedule$all_successors()}}
\item \href{#method-all_predecessors}{\code{Schedule$all_predecessors()}}
\item \href{#method-is_redundant}{\code{Schedule$is_redundant()}}
\item \href{#method-change_durations}{\code{Schedule$change_durations()}}
\item \href{#method-gantt_matrix}{\code{Schedule$gantt_matrix()}}
\item \href{#method-xy_gantt_matrix}{\code{Schedule$xy_gantt_matrix()}}
\item \href{#method-topoi_sp}{\code{Schedule$topoi_sp()}}
\item \href{#method-topoi_ad}{\code{Schedule$topoi_ad()}}
\item \href{#method-topoi_la}{\code{Schedule$topoi_la()}}
\item \href{#method-topoi_tf}{\code{Schedule$topoi_tf()}}
\item \href{#method-clone}{\code{Schedule$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Make a schedule with activities and relations between activities.
The method \code{Schedule$new(activities, relations)}
creates an schedule object from two data frames,
one containing activities lists and the other the precedence relations
between activities.
After creation, it is applied the Critical Path Method (CPM).

It is possible to create a empty schedule, without any activity or relation
with the constructor \code{Schedule$new()}.
After that, it is possible to add activity with \code{add_activity}
and relation with \code{add_relation} methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$new(activities = NULL, relations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{activities}}{Data frame with activities.
If it is not informed, the schedule will be created without any activity.
Its structure is:
\itemize{
\item \strong{id:} Activity id. It is an integer number that
must be unique within a schedule.
\item \strong{name:} Activity name. It may be empty.
\item \strong{duration:} Activity duration. It is integer number without unit time.
It may be zero.
}}

\item{\code{relations}}{Data frame with precedence relations between activities.
If it is informed, the activities has to be informed too.
If it is not informed, the schedule will be created without any relation.
It is formed by predecessor activity e successor activity.
Its structure is:
\itemize{
\item \strong{from:} The id of predecessor activity. Must exist an activity with from id.
\item \strong{to:} The id of successor activity. Must exist an activity with to id.
\item \strong{type:} Specifies the type of relation between activities.
The default type is FS and its value may be: FS, FF, SS, SF, that means:
\itemize{
\item \strong{FS:} Finish-Start relation.
Activity to_id can only start after the finish of activity from_id.
\item \strong{FF:} Finish-Finish relation.
Activity to_id must finish together with activity from_id.
\item \strong{SS:} Start-Start relation.
Activity to_id must start together with activity from_id.
\item \strong{SF:} Start-Finish relation.
Activity to_id must finish when activity from_id starts.
}
\item \strong{lag:} The time period between activities that the successor activity
must be advanced, or lated, after activity from_id.
It must be an integer, less than, equal or greater than zero.
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object with CPM parameters calculated.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# An empty schedule.
schedule <- Schedule$new()
schedule$duration
schedule$activities
schedule$relations

# A schedule with activities and relations.
activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,2,2,4,3,3,3,2,1,1,2,1,1,1,1,2,1)
)

relations <- data.frame(
  from = c(1, 1, 2, 2, 2, 3, 3, 3,  3,  4,  5,  6,
           7,  8,  9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15),
  to   = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 11,
           12, 13, 14, 15, 16, 17, 16, 17, 16, 17, 16, 17, 16, 17)
)
schedule <- Schedule$new(activities, relations)
schedule$title <- "Project 1: Cost Information System"
schedule$reference <- "VANHOUCKE, Mario.
Integrated project management and control:
  first comes the theory, then the practice.
  Gent: Springer, 2014, p. 6"
schedule$duration
schedule$activities
schedule$relations

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_activity"></a>}}
\if{latex}{\out{\hypertarget{method-add_activity}{}}}
\subsection{Method \code{add_activity()}}{
Add an activity to a schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$add_activity(id, name = "", duration = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Activity id that will be used to make
relation between activities. It must be unique.}

\item{\code{name}}{The name of activity. The default is an empty string.}

\item{\code{duration}}{A number that represents the activity's duration.
It must be equal or greater than zero. The default value is zero.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object with an activity added and
the critical path calculated.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{schedule <- Schedule$new()
schedule$add_activity(1, "Task 1", 5)
schedule$add_activity(2, "Task 2", 6)
schedule$add_activity(3, "Task 3", 8)
schedule$add_activity(4, "Task 4", 6)
schedule$add_activity(5, "Task 5", 9)
schedule$add_activity(6, "Task 6", 3)
schedule$add_activity(7, "Task 7", 4)
schedule$duration
schedule$activities
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_activities"></a>}}
\if{latex}{\out{\hypertarget{method-add_activities}{}}}
\subsection{Method \code{add_activities()}}{
Add activities from a data frame to a schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$add_activities(activities)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{activities}}{A data frame with the activities to be added.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object with activities added and CPM calculated.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,2,2,4,3,3,3,2,1,1,2,1,1,1,1,2,1)
)
schedule <- Schedule$new()
schedule$add_activities(activities)
schedule$duration
schedule$activities
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_activity"></a>}}
\if{latex}{\out{\hypertarget{method-get_activity}{}}}
\subsection{Method \code{get_activity()}}{
Gets an activity by id. It returns a data
frame with one line about activity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$get_activity(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{An activity id as defined by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with one line with the activity,
or an error if activity id doesn't exist.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{x <- runif(1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_relation"></a>}}
\if{latex}{\out{\hypertarget{method-add_relation}{}}}
\subsection{Method \code{add_relation()}}{
Add a relation to a schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$add_relation(from, to, type = "FS", lag = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{The id of predecessor activity.
Must exist an activity with from.}

\item{\code{to}}{The id of successor activity.
Must exist an activity with to.}

\item{\code{type}}{Specifies the type of relation between activities.
The default type is FS and its value may be: FS, FF, SS, SF, that means:
If type is not defined, it is assumed to be FS.

\strong{FS:} Finish-Start relation.
Activity 'to' id can only start after the finish of activity 'from' id.

\strong{FF:} Finish-Finish relation.
Activity 'to' id must finish together with activity 'from' id.

\strong{SS:} Start-Start relation.
Activity 'to' id must start together with activity 'from' id.

\strong{SF:} Start-Finish relation.
Activity 'to' id must finish when activity 'from' id starts.}

\item{\code{lag}}{The time period between activities that the successor activity
'to' must be advanced after activity 'from' has been finished.
The value may be negative, in such case, the activity 'to' will be
anticipated 'lag' time periods.
It must be an integer, less than, equal or greater than zero.
If lag is not defined, it is assumed to be zero.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object with CPM parameters calculated.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# First, create an empty schedule
schedule <- Schedule$new()
schedule$title <- "Project 3: Old Carriage House Renovation"
schedule$reference <-
  "VANHOUCKE, Mario. Integrated project management and control:
  first comes the theory, then the practice. Gent: Springer, 2014, p. 11"

# Second, add activities to it
schedule$add_activity(1, "a1" , 2)
schedule$add_activity(2, "a2" , 2)
schedule$add_activity(3, "a3" , 4)
schedule$add_activity(4, "a4" , 3)
schedule$add_activity(5, "a5" , 4)
schedule$add_activity(6, "a6" , 1)
schedule$add_activity(7, "a7" , 1)
schedule$add_activity(8, "a8" , 1)
schedule$add_activity(9, "a9" , 1)
schedule$add_activity(10, "a10", 1)
schedule$add_activity(11, "a11", 3)
schedule$add_activity(12, "a12", 2)
schedule$add_activity(13, "a13", 1)
schedule$add_activity(14, "a14", 1)
schedule$add_activity(15, "a15", 2)
schedule$add_activity(16, "a16", 1)
schedule$add_activity(17, "a17", 1)

# Finally, add relations to it
schedule$add_relation( 1, 2)
schedule$add_relation( 2, 3)
schedule$add_relation( 3, 4)
schedule$add_relation( 4, 5)
schedule$add_relation( 5, 6)
schedule$add_relation( 6, 7)
schedule$add_relation( 6, 8)
schedule$add_relation( 6, 9)
schedule$add_relation( 7, 10)
schedule$add_relation( 8, 10)
schedule$add_relation( 9, 10)
schedule$add_relation( 10, 11)
schedule$add_relation( 10, 13)
schedule$add_relation( 11, 12)
schedule$add_relation( 12, 15)
schedule$add_relation( 13, 14)
schedule$add_relation( 14, 15)
schedule$add_relation( 15, 16)
schedule$add_relation( 16, 17)
schedule$duration
schedule$activities
schedule$relations
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_relations"></a>}}
\if{latex}{\out{\hypertarget{method-add_relations}{}}}
\subsection{Method \code{add_relations()}}{
Add relations between activities from a data frame
to a schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$add_relations(relations)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relations}}{A data frame with the relations to be added.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object with relations added and CPM calculated.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# A schedule with activities and relations.
activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,2,2,4,3,3,3,2,1,1,2,1,1,1,1,2,1)
)

relations <- data.frame(
  from = c(1, 1, 2, 2, 2, 3, 3, 3,  3,  4,  5,  6,
           7,  8,  9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15),
  to   = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 11,
           12, 13, 14, 15, 16, 17, 16, 17, 16, 17, 16, 17, 16, 17)
)
schedule <- Schedule$new(activities)
schedule$title <- "Project 1: Cost Information System"
schedule$reference <- "VANHOUCKE, Mario.
Integrated project management and control:
  first comes the theory, then the practice.
  Gent: Springer, 2014, p. 6"
schedule$relations # Empty

schedule$add_relations(relations)
schedule$relations # Not empty

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_act_rel"></a>}}
\if{latex}{\out{\hypertarget{method-add_act_rel}{}}}
\subsection{Method \code{add_act_rel()}}{
Add an activity and her relations to a schedule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$add_act_rel(
  id,
  name,
  duration,
  relations_id = c(),
  direction = "succ"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Activity id. The id will be used to make relation between activities.}

\item{\code{name}}{The name of activity.}

\item{\code{duration}}{A number that represents the activity's duration.
It must be equal or greater than zero.}

\item{\code{relations_id}}{A vector of ids such that will be linked with activity id.
It may be relations of successor or predecessors.}

\item{\code{direction}}{Direction of relations_id: It may be "succ" or "pred".
If dir="succ" the relations_id will be the successor of the activity.
If dir="pred" the relations_id will be the predecessor of the activity.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)
schedule$duration
schedule$activities
schedule$relations
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print a description of the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Variable parameters}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A String .
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"
schedule
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-all_successors"></a>}}
\if{latex}{\out{\hypertarget{method-all_successors}{}}}
\subsection{Method \code{all_successors()}}{
List all successors from an activity: direct and indirect successors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$all_successors(id, ign_to = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Activity id to be listed.}

\item{\code{ign_to}}{A relation to be ignored: id -> ign_to.
Activities from this relation will be ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector whith all activities ids.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  2, "a2" , 4, c(5, 12))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$all_successors(2) # 5, 9, 12
schedule$all_successors(7) # 8, 11, 12
schedule$all_successors(10) # 12

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-all_predecessors"></a>}}
\if{latex}{\out{\hypertarget{method-all_predecessors}{}}}
\subsection{Method \code{all_predecessors()}}{
List all predecessors from an activity: direct or indirect predecessors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$all_predecessors(id, ign_from = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Activity id to be listed.}

\item{\code{ign_from}}{A relation to be ignored: ign_from -> id.
Activities from this relation will be ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector with all activities ids.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  2, "a2" , 4, c(5, 12))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$all_predecessors(2) # nothing
schedule$all_predecessors(7) # 6, 4
schedule$all_predecessors(10) # 3

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_redundant"></a>}}
\if{latex}{\out{\hypertarget{method-is_redundant}{}}}
\subsection{Method \code{is_redundant()}}{
Verify if a relation between two activities is redundant.
A relation A->C is redundant if there are A->C, A->B, B->C relations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$is_redundant(id_from, id_to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id_from}}{From activity id.}

\item{\code{id_to}}{To activity id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical \code{TRUE} if an arc is redundant;
\code{FALSE} if it is not.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  2, "a2" , 4, c(5, 12))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$is_redundant(2, 5)  #FALSE
schedule$is_redundant(2, 12) #TRUE

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-change_durations"></a>}}
\if{latex}{\out{\hypertarget{method-change_durations}{}}}
\subsection{Method \code{change_durations()}}{
Change activities duration and calculate critical path.
This way is faster than creating a new schedule with new durations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$change_durations(new_durations)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_durations}}{A vector with new activities' duration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Schedule object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{activities <- data.frame(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1,1,3,2, 2,2,2,1, 4,5,3,3, 4,5,1,5,2)
)

relations <- data.frame(
  from = c(1, 2, 3, 3, 4, 5, 6, 7, 8,  8,  8,
    8,  8,  9, 10, 11, 12, 13, 13, 14, 14, 15, 15),
  to   = c(2, 3, 4, 6, 5, 8, 7, 8, 9, 10, 11,
   12, 13, 14, 14, 14, 14, 14, 15, 16, 17, 16, 17)
)

schedule <- Schedule$new(activities, relations)
schedule$title <- "Project 2: Patient Transport System"
schedule$reference <-
  "VANHOUCKE, Mario. Integrated project management and control:
  first comes the theory, then the practice. Gent: Springer, 2014, p. 9"
#Project duration
schedule$duration # 25
#Activities duration
schedule$activities$duration

# Now, change activities duration
new_durations <- c(1,2,5, 4,3, 2,1, 5, 3,5,5,3,4, 2,1, 2,4)
schedule$change_durations(new_durations)

#Project duration
schedule$duration # 31
#Activities duration
schedule$activities$duration

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gantt_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-gantt_matrix}{}}}
\subsection{Method \code{gantt_matrix()}}{
Create a matrix that represents a Gantt chart,
a matrix where "1" indicates that an activity is planned to be
in execution.

In this matrix, the rows represent activities,
whereas the columns represents the activity execution period.
So, the number of columns is equal to project duration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$gantt_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A matrix where "1" indicates that an activity is in execution.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{activities <- data.frame(
  id        = c( 1,   2,   3,   4 ),
  name      = c("A", "B", "C", "D"),
  duration  = c( 2,   3,   1,   2 )
)
relations <- data.frame(
  from = c(1, 2, 4, 4),
  to   = c(3, 3, 1, 2)
)
schedule <- Schedule$new(activities, relations)
gantt <- schedule$gantt_matrix()
gantt
# What is the effort by time period?
colSums(gantt) # 1 1 2 2 1 1
# What is the duration by activities?
rowSums(gantt) # 2 3 1 2
# what is the S curve
cumsum(colSums(gantt))
plot(cumsum(colSums(gantt)), type="l", lwd=3)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xy_gantt_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-xy_gantt_matrix}{}}}
\subsection{Method \code{xy_gantt_matrix()}}{
Transform a Gantt matrix in x, y coordinates and the weight one.
Each point greater than zero in a Gantt matrix becomes a x, y coordinate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$xy_gantt_matrix(gantt = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gantt}}{A Gantt Matrix. If it is not informed, it will use
\code{gantt_matrix()} before this function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix x, y and weight.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{activities <- data.frame(
  id        = c( 1,   2,   3,   4 ),
  name      = c("A", "B", "C", "D"),
  duration  = c( 2,   3,   1,   2 )
)
relations <- data.frame(
  from = c(1, 2, 4, 4),
  to   = c(3, 3, 1, 2)
)
schedule <- Schedule$new(activities, relations)
gantt <- schedule$gantt_matrix()
xyw <- schedule$xy_gantt_matrix()
xyw
plot(xyw[, 1:2])

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-topoi_sp"></a>}}
\if{latex}{\out{\hypertarget{method-topoi_sp}{}}}
\subsection{Method \code{topoi_sp()}}{
\strong{SP Serial or Parallel Topological Indicator:}
It shows the closeness of a network to a serial or parallel graph.
As the network becomes serial, the SP increase, until one,
when the network totally serial.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$topoi_sp()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1, inclusive.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_sp()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-topoi_ad"></a>}}
\if{latex}{\out{\hypertarget{method-topoi_ad}{}}}
\subsection{Method \code{topoi_ad()}}{
\strong{AD Activity Distribution Topological Indicator:}
Measures the distribution of the activities over the levels.
If AD is approximately equal zero, each level has same numbers of activities.
Otherwise, if AD is equal one, the quantity of each level is not
uniformly distributed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$topoi_ad()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1, inclusive.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_ad()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-topoi_la"></a>}}
\if{latex}{\out{\hypertarget{method-topoi_la}{}}}
\subsection{Method \code{topoi_la()}}{
\strong{LA Length of Arcs Topological Indicator:}
Measures the presence of long arcs based on the difference between
the progressive level of the end activity and the start node
of each relation.
If LA is approximately equal zero, the progressive level between
activities is as far as possible.
Otherwise, if LA is equal one, the relation distance are one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$topoi_la()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1, inclusive.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_la()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-topoi_tf"></a>}}
\if{latex}{\out{\hypertarget{method-topoi_tf}{}}}
\subsection{Method \code{topoi_tf()}}{
\strong{TF Topological Float Indicator:}
Measures the topological float of each activity.
If TF = 0, there is no float between activities.
If TF = 1, there is float between activities
and they be shift without affecting other activities.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$topoi_tf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1, inclusive.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a schedule
schedule <- Schedule$new()
schedule$title <- "Fictitious Project Example"
schedule$reference <- "VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18"

# Add activities and relations to it.
schedule$add_act_rel(  1, "a1" , 0, c(2,3,4))
schedule$add_act_rel(  2, "a2" , 4, c(5))
schedule$add_act_rel(  3, "a3" , 9, c(10))
schedule$add_act_rel(  4, "a4" , 1, c(6))
schedule$add_act_rel(  5, "a5" , 4, c(9))
schedule$add_act_rel(  6, "a6" , 5, c(7))
schedule$add_act_rel(  7, "a7" , 1, c(8,11))
schedule$add_act_rel(  8, "a8" , 7, c(12))
schedule$add_act_rel(  9, "a9" , 8, c(12))
schedule$add_act_rel( 10, "a10", 3, c(12))
schedule$add_act_rel( 11, "a11", 3, c(12))
schedule$add_act_rel( 12, "a12", 0)

schedule$topoi_tf()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Schedule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
