% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{NN}
\alias{NN}
\title{NN Function}
\usage{
NN(
  batch.size = 8192,
  code = "mcnp",
  dataset,
  ensemble.size = 5,
  epochs = 1500,
  layers = "8192-256-256-256-256-16",
  loss = "sse",
  opt.alg = "adamax",
  learning.rate = 0.00075,
  val.split = 0.2,
  replot = TRUE,
  verbose = FALSE,
  ext.dir,
  training.dir = NULL
)
}
\arguments{
\item{batch.size}{Batch size}

\item{code}{Monte Carlo radiation transport code (e.g., "cog", "mcnp")}

\item{dataset}{Training and test data}

\item{ensemble.size}{Number of deep neural networks in the ensemble}

\item{epochs}{Number of training epochs}

\item{layers}{String that defines the deep neural network architecture (e.g., "64-64")}

\item{loss}{Loss function}

\item{opt.alg}{Optimization algorithm}

\item{learning.rate}{Learning rate}

\item{val.split}{Validation split}

\item{replot}{Boolean (TRUE/FALSE) that determines if .png files should be replotted}

\item{verbose}{Boolean (TRUE/FALSE) that determines if TensorFlow and Test function output should be displayed}

\item{ext.dir}{External directory (full path)}

\item{training.dir}{Training directory (full path)}
}
\value{
A list of lists containing an ensemble of deep neural networks and weights
}
\description{
This function imports the Tabulate, Scale, Model, Fit, Plot, and Test functions to train an ensemble of deep neural networks to predict keff values.
}
\examples{

ext.dir <- paste0(tempdir(), "/criticality/extdata")
dir.create(ext.dir, recursive = TRUE, showWarnings = FALSE)

extdata <- paste0(.libPaths()[1], "/criticality/extdata")
file.copy(paste0(extdata, "/facility.csv"), ext.dir, recursive = TRUE)
file.copy(paste0(extdata, "/mcnp-dataset.RData"), ext.dir, recursive = TRUE)

config <- FALSE
try(config <- reticulate::py_config()$available)
try(if (config == TRUE) {
  NN(
    batch.size = 128,
    code = "mcnp",
    ensemble.size = 1,
    epochs = 10,
    layers = "8192-256-256-256-256-16",
    loss = "sse",
    opt.alg = "adamax",
    learning.rate = 0.00075,
    val.split = 0.2,
    replot = FALSE,
    verbose = FALSE,
    ext.dir = ext.dir
  )
})

}
