% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bayes_clustering.R
\name{bayesPairs}
\alias{bayesPairs}
\alias{bayesProb}
\title{Extracts the crimes with the largest probability of being linked.}
\usage{
bayesPairs(p.equal, drop = 0)

bayesProb(prob, drop = 0)
}
\arguments{
\item{p.equal}{the posterior probability matrix produced by
  \code{\link{crimeClust_bayes}}}

\item{drop}{only return crimes with a posterior linkage probability that
 exceeds drop. Set to NA to return all results.}

\item{prob}{a column (or row) of the posterior probability matrix produced by
  \code{\link{crimeClust_bayes}}}
}
\value{
data.frame of the indices of crimes with estimated posterior
  probabilities, ordered from largest to smallest
}
\description{
Extracts the crimes (from \code{\link{crimeClust_bayes}}) with the largest
 probability of being linked.
}
\details{
This is a helper function to easily extract the crimes with a high
  probability of being linked from the output of \code{\link{crimeClust_bayes}}.
  \code{bayesPairs} searches the full posterior probability matrix and
  \code{bayesProb} only searches a particular column (or row).
}
\seealso{
\code{\link{crimeClust_bayes}}
}

