% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_player_id.R
\name{find_player_id}
\alias{find_player_id}
\title{Find a player id from cricinfo.com}
\usage{
find_player_id(searchstring)
}
\arguments{
\item{searchstring}{Part of a player name(s) to search for. Can be a character vector.}
}
\value{
A table of matching players, their ids, and teams they played for.
}
\description{
Find a player id from cricinfo.com
}
\examples{
\dontrun{
(perry <- find_player_id("Perry"))
EllysePerry <- fetch_player_data(perry[2,"ID"], "test")
}
}
\seealso{
\code{\link[=fetch_player_data]{fetch_player_data()}} to download playing statistics for
a player, and \code{\link[=fetch_player_meta]{fetch_player_meta()}} to download meta data on players.
}
\author{
Rob J Hyndman
}
