% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{crf_options}
\alias{crf_options}
\title{Conditional Random Fields parameters}
\usage{
crf_options(
  method = c("lbfgs", "l2sgd", "averaged-perceptron", "passive-aggressive", "arow")
)
}
\arguments{
\item{method}{character string with the type of training method. Either one of:
\itemize{
 \item{lbfgs: }{L-BFGS with L1/L2 regularization}
 \item{l2sgd: }{SGD with L2-regularization}
 \item{averaged-perceptron: }{Averaged Perceptron}
 \item{passive-aggressive: }{Passive Aggressive}
 \item{arow: }{Adaptive Regularization of Weights (AROW)}
}}
}
\value{
a list with elements 
\itemize{
 \item{method: }{The training method}
 \item{type: }{The type of graphical model which is always set crf1d: Linear-chain (first-order Markov) CRF}
 \item{params: }{A data.frame with fields arg, arg_default and description indicating the possible hyperparameters of the algorithm, the default values and the description}
 \item{default: }{A list of default values which can be used to pass on to the \code{options} argument of \code{\link{crf}}}
}
}
\description{
Conditional Random Fields parameters
}
\examples{
# L-BFGS with L1/L2 regularization
opts <- crf_options("lbfgs")
str(opts)

# SGD with L2-regularization
crf_options("l2sgd")

# Averaged Perceptron
crf_options("averaged-perceptron")

# Passive Aggressive
crf_options("passive-aggressive")

# Adaptive Regularization of Weights (AROW)
crf_options("arow")
}
