% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_clean.R
\name{crew_clean}
\alias{crew_clean}
\title{Terminate dispatchers and/or workers}
\usage{
crew_clean(
  dispatchers = TRUE,
  workers = TRUE,
  user = Sys.getenv("USER"),
  seconds_interval = 0.1,
  seconds_timeout = 10,
  verbose = TRUE
)
}
\arguments{
\item{dispatchers}{Logical of length 1,
whether to terminate dispatchers.}

\item{workers}{Logical of length 1,
whether to terminate workers.}

\item{user}{Character of length 1. Terminate dispatchers and/or
workers associated with this user name.}

\item{seconds_interval}{Seconds to between polling intervals
waiting for a process to exit.}

\item{seconds_timeout}{Seconds to wait for a process to exit.}

\item{verbose}{Logical of length 1, whether to print an informative
message every time a process is terminated.}
}
\value{
\code{NULL} (invisibly). If \code{verbose} is \code{TRUE}, it does
print out a message for every terminated process.
}
\description{
Terminate \code{mirai} dispatchers and/or \code{crew} workers
which may be lingering from previous workloads.
}
\details{
Behind the scenes, \code{mirai} uses an external R process
called a "dispatcher" to send tasks to \code{crew} workers.
This dispatcher usually shuts down when you terminate the controller
or quit your R session, but sometimes it lingers. Likewise,
sometimes \code{crew} workers do not shut down on their own.
The \code{crew_clean()} function searches the process table on your
local machine and manually terminates any \code{mirai} dispatchers
and \code{crew} workers associated with your user name (or the
user name you select in the \code{user} argument.
Unfortunately, it cannot reach remote workers such as those
launched by a \code{crew.cluster} controller.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_clean()
}
}
\seealso{
Other user: 
\code{\link{crew-package}},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller_local}()}
}
\concept{user}
