## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----img1, echo=FALSE, fig.cap="**Fig. 1**: (left) Climate variable to reconstruct (*e.g.* mean annual temperature). (Right) Four distinct plant taxa living in that region and having a preference for the darker climates (*e.g.* a preference for colder climates). These four species produce undistinguisable pollen grains and, therefore, define a 'pollen type'. This example is based on pseudo-data.", out.width = '80%', fig.align = 'center', out.extra='style="background:none; border:none; box-shadow:none;"'----
knitr::include_graphics("https://raw.githubusercontent.com/mchevalier2/crestr/master/docs/articles/theory_files/figure-html/crest-01.png")

## ----img2, echo=FALSE, fig.cap="**Fig. 2**: Climate responses of the four plant species presented on **Fig. 1** (coloured curves). Their individual responses are combined together to create the response of the pollen taxon in black. The histogram inset represents the distribution of the climate space available (white) and which part of this climate space is occupied by at least one species (in black).", out.width = '40%', fig.align = 'center', out.extra='style="background:none; border:none; box-shadow:none;"'----
knitr::include_graphics("https://raw.githubusercontent.com/mchevalier2/crestr/master/docs/articles/theory_files/figure-html/crest-02.png")

## ----img3, echo=FALSE, fig.cap="**Fig. 3**: Posterior distribution of probabilities conditioned by the existence of certain fossil taxa observed with certain proportions. This distribution can be simplified to single number, such as the mean or the mode/optimum (_i.e._ the most likely) probability.", out.width = '40%', fig.align = 'center', out.extra='style="background:none; border:none; box-shadow:none;"'----
knitr::include_graphics("https://raw.githubusercontent.com/mchevalier2/crestr/master/docs/articles/theory_files/figure-html/crest-03.png")

