% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spread_to_upfront.R
\name{spread_to_upfront}
\alias{spread_to_upfront}
\title{Calculate Upfront Payments}
\usage{
spread_to_upfront(x, currency.var = "currency", notional = 1e+07,
  date.var = "date", spread.var = "spread", coupon.var = "coupon",
  tenor.var = "tenor", maturity.var = "maturity",
  recovery.var = "recovery", isPriceClean = FALSE)
}
\arguments{
\item{x}{data frame, contains all the relevant columns.}

\item{currency.var}{character, column in x containing currency.}

\item{notional}{is the amount of the underlying asset on which the
payments are based. Default is 10000000, i.e. 10MM.}

\item{date.var}{character, column in x containing date variable.}

\item{spread.var}{character, column in x containing spread in basis points.}

\item{coupon.var}{character, column in x containing coupon rates in basis
points. It specifies the payment amount from the protection buyer to the
seller on an annual basis.}

\item{tenor.var}{character, column in x containing tenors.}

\item{maturity.var}{character, column in x containing maturity date.}

\item{recovery.var}{character, column in x containing recovery rates. ISDA
model standard recovery rate asscumption is 0.4.}

\item{isPriceClean}{refers to the type of upfront calculated. It is
       boolean. When \code{TRUE}, calculate principal only. When
       \code{FALSE}, calculate principal + accrual.}
}
\value{
vector of upfront values (with accrual) in the same order
}
\description{
\code{spread_to_upfront} takes a dataframe of variables on CDSs to return
a vector of upfront values. Note that all CDS in the data frame must be denominated in
the same currency.
}

