#' creditmodel: toolkit for credit modeling and data analysis
#'
#' creditmodel provides a highly efficient R tool suite for Credit Modeling, Analysis and Visualization. 
#' Contains infrastructure functionalities such as data exploration and preparation, missing values treatment, outliers treatment, 
#' variable derivation, variable selection, dimensionality reduction, grid search for hyper parameters, data mining and visualization, model evaluation, strategy analysis etc. 
#' This package is designed to make the development of binary classification models (machine learning based models as well as credit scorecard) simpler and faster. 
#'
#' It has three main goals:
#'
#' \itemize{
#' \item creditmodel is a free and open source automated modeling R package designed to help model developers improve 
#' model development efficiency and enable many people with no background in data science to complete the modeling work in a short time.
#' Let them focus more on the problem itself and allocate more time to decision-making.
#' \item creditmodel covers various tools such as data preprocessing, variable processing/derivation, 
#' variable screening/dimensionality reduction, modeling, data analysis, data visualization, model evaluation, strategy analysis, etc. 
#' It is a set of customized "core" tool kit for model developers.
#' \item `creditmodel` is suitable for machine learning automated modeling of classification targets, 
#' and is more suitable for the risk and marketing data of financial credit, e-commerce, and insurance 
#' with relatively high noise and low information content.
#' }
#'
#' To learn more about creditmodel, start with the WeChat Platform: hansenmode
#'
"_PACKAGE"
