% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_table}
\alias{plot_table}
\title{plot_table}
\usage{
plot_table(grid_table, theme = c("cyan", "grey", "green", "red", "blue",
  "purple"), title = NULL, title.size = 12, title.color = "black",
  title.face = "bold", title.position = "middle", subtitle = NULL,
  subtitle.size = 8, subtitle.color = "black",
  subtitle.face = "plain", subtitle.position = "middle",
  tile.color = "white", tile.size = 1, colname.size = 3,
  colname.color = "white", colname.face = "bold",
  colname.fill.color = love_color("dark_cyan"), text.size = 3,
  text.color = love_color("dark_grey"), text.face = "plain",
  text.fill.color = c("white", love_color("pale_grey")))
}
\arguments{
\item{grid_table}{A data.frame or table}

\item{theme}{The theme of color, "cyan","grey","green","red","blue","purple" are available.}

\item{title}{The title of table}

\item{title.size}{The title size of plot.}

\item{title.color}{The title color.}

\item{title.face}{The title face, such as "plain", "bold".}

\item{title.position}{The title position,such as "left","middle","right".}

\item{subtitle}{The subtitle of table}

\item{subtitle.size}{The subtitle size.}

\item{subtitle.color}{The subtitle color.}

\item{subtitle.face}{The subtitle face, such as "plain", "bold",default is "bold".}

\item{subtitle.position}{The subtitle position,such as "left","middle","right", default is "middle".}

\item{tile.color}{The color of table lines, default is 'white'.}

\item{tile.size}{The size of table lines , default is 1.}

\item{colname.size}{The size of colnames, default is 3.}

\item{colname.color}{The color of colnames, default is 'white'.}

\item{colname.face}{The face of colnames,default is 'bold'.}

\item{colname.fill.color}{The fill color of colnames, default is love_color("dark_cyan").}

\item{text.size}{The size of text, default is 3.}

\item{text.color}{The color of text, default is love_color("dark_grey").}

\item{text.face}{The face of text, default is 'plain'.}

\item{text.fill.color}{The fill color of text, default is c('white',love_color("pale_grey").}
}
\description{
\code{plot_table} is for table visualizaiton.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1))
dat = process_nas(dat,default_miss = TRUE)
train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))

dat_train$pred_LR = round(predict(lr_model, dat_train[, x_list], type = "response"), 5)
dat_test$pred_LR = round(predict(lr_model, dat_test[, x_list], type = "response"), 5)
# model evaluation
t1 = perf_table(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
plot_table(t1)
}
