% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepdown.R
\name{outname_fit}
\alias{outname_fit}
\title{Extracts the dependent variable name from glm, lm, or mer model}
\usage{
outname_fit(fit)
}
\arguments{
\item{fit}{A fitted model object of class glm, lm, or *merMod}
}
\value{
A string with the name of the dependent variable from the model
}
\description{
Extracts the dependent variable name from glm, lm, or mer model
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
fit1 <- lme4::glmer(y1 ~ treat + (1|cl) ,
                    data=data,
                    family="poisson")
outname_fit(fit1)
}
