% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcmc_mix1}
\alias{mcmc_mix1}
\title{Markov chain Monte Carlo for TZP-power-law mixture}
\usage{
mcmc_mix1(
  x,
  count,
  u_set,
  u,
  alpha1,
  theta1,
  alpha2,
  a_psiu,
  b_psiu,
  a_alpha1,
  b_alpha1,
  a_theta1,
  b_theta1,
  a_alpha2,
  b_alpha2,
  positive,
  iter,
  thin,
  burn,
  freq,
  invt,
  mc3_or_marg,
  xmax
)
}
\arguments{
\item{x}{Vector of the unique values (positive integers) of the data}

\item{count}{Vector of the same length as x that contains the counts of each unique value in the full data, which is essentially rep(x, count)}

\item{u_set}{Positive integer vector of the values u will be sampled from}

\item{u}{Positive integer, initial value of the threshold}

\item{alpha1}{Real number, initial value of the parameter}

\item{theta1}{Real number in (0, 1], initial value of the parameter}

\item{alpha2}{Real number greater than 1, initial value of the parameter}

\item{a_psiu, b_psiu, a_alpha1, b_alpha1, a_theta1, b_theta1, a_alpha2, b_alpha2}{Scalars, real numbers representing the hyperparameters of the prior distributions for the respective parameters. See details for the specification of the priors.}

\item{positive}{Boolean, is alpha positive (TRUE) or unbounded (FALSE)?}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{invt}{Vector of the inverse temperatures for Metropolis-coupled MCMC}

\item{mc3_or_marg}{Boolean, is invt for parallel tempering / Metropolis-coupled MCMC (TRUE, default) or marginal likelihood via power posterior (FALSE)?}

\item{xmax}{Scalar, positive integer limit for computing the normalising constant}
}
\value{
A list: $pars is a data frame of iter rows of the MCMC samples, $fitted is a data frame of length(x) rows with the fitted values, amongst other quantities related to the MCMC
}
\description{
\code{mcmc_mix1} returns the posterior samples of the parameters, for fitting the TZP-power-law mixture distribution. The samples are obtained using Markov chain Monte Carlo (MCMC).
}
\details{
In the MCMC, a componentwise Metropolis-Hastings algorithm is used. The threshold u is treated as a parameter and therefore sampled. The hyperparameters are used in the following priors: u is such that the implied unique exceedance probability psiu ~ Uniform(a_psi, b_psi); alpha1 ~ Normal(mean = a_alpha1, sd = b_alpha1); theta1 ~ Beta(a_theta1, b_theta1); alpha2 ~ Normal(mean = a_alpha2, sd = b_alpha2)
}
\seealso{
\code{\link{mcmc_pol}}, \code{\link{mcmc_mix2}} and \code{\link{mcmc_mix3}} for MCMC for the Zipf-polylog, and 2-component and 3-component discrete extreme value mixture distributions, respectively.
}
