% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Smix}
\alias{Smix}
\title{Survival function of discrete extreme value mixture distribution}
\usage{
Smix(x, xi1, xi2, sig, u, phi, geo)
}
\arguments{
\item{x}{Vector of positive integers}

\item{xi1}{Scalar, shape parameter for values below or equal to u}

\item{xi2}{Scalar, shape parameter of integer generalised Pareto distribution (IGPD), for values above u}

\item{sig}{Scalar, scale parameter of IGPD, for values above u}

\item{u}{Scalar, positive integer threshold}

\item{phi}{Scalar, exceedance probability of u, between 0.0 and 1.0 exclusive}

\item{geo}{Boolean. If 'TRUE', the geometric distribution is used for the values below u. If 'FALSE', the discrete power law is used.}
}
\value{
A numeric vector of the same length as x
}
\description{
\code{Smix} returns the survival function at x for the discrete extreme value mixture distribution.
}
\examples{
Smix(10:15, 2.0, 0.5, 1.0, 12, 0.2, TRUE)
Smix(10:15, 2.0, 0.5, 1.0, 12, 0.2, FALSE)
}
\seealso{
\code{\link{dmix}} for the corresponding probability mass function, \code{\link{Supp}} for the survival function of the discrete power law.
}
