% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitAndTestSurvival.R
\name{testSurvival}
\alias{testSurvival}
\title{Fleming-Harrington test for differences between groups}
\usage{
testSurvival(time, risk, group, cens = 0, rho = 0)
}
\arguments{
\item{time}{vector with times of the first event or follow-up, must be numeric.}

\item{risk}{vector with type of event, can be numeric or factor/character.}

\item{group}{vector with group variable, can be numeric or factor/character.}

\item{cens}{value of 'risk' indicating censored observation (default 0).}

\item{rho}{rho parameter from Fleming-Harrington Test.}
}
\value{
a data.frame containing p-values of Fleming-Harrington Test for each risk.
}
\description{
Tests, if there are differences between groups for survival curves estimating for all risks separately (treating other events as censoring).
}
\examples{
testSurvival(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive", rho = 0)
}
\seealso{
\code{\link[survival]{survdiff}}
}
