% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expfns.R
\name{exp_icdf}
\alias{exp_icdf}
\title{Inverse CDF for the exponential distribution}
\usage{
exp_icdf(u, theta)
}
\arguments{
\item{u}{Numerical value(s) to be converted to exponential variable(s)}

\item{theta}{Scale parameter \eqn{\theta}}
}
\value{
If inputs are numeric, output is a value or a vector of values
from the inverse CDF of the exponential distribution.
}
\description{
\code{exp_icdf} simulates values from the inverse CDF of the
exponential distribution.
}
\details{
This function uses the exponential distribution of the form
\deqn{f(t)=\theta exp(-\theta t)}
to get the inverse CDF
\deqn{F^(-1)(u)=(-log(1-u))/\theta.} It can be
implemented directly and is also called by the functions
\code{\link{exp_memsim}} and \code{\link{exp_cdfsim}}.
}
\examples{
simdta <- exp_icdf(u = runif(10), theta = 0.05)

}
