% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpm.R
\name{cpm}
\alias{cpm}
\title{Perform Connectome-based Predictive Modeling (CPM)}
\usage{
cpm(
  conmat,
  behav,
  ...,
  confounds = NULL,
  thresh_method = c("alpha", "sparsity"),
  thresh_level = 0.01,
  kfolds = NULL,
  bias_correct = TRUE,
  return_edges = c("none", "sum", "all")
)
}
\arguments{
\item{conmat}{A matrix of connectome data. Observations in row, edges in
column (assumed that duplicated edges are removed).}

\item{behav}{A numeric vector contains behavior data. Length must equal to
number of observations in \code{conmat}. Note \code{behav} could also be a row/column
matrix, which will be converted to a vector using \code{\link[=drop]{drop()}}.}

\item{...}{For future extension. Currently ignored.}

\item{confounds}{A matrix of confounding variables. Observations in row,
variables in column. If \code{NULL}, no confounding variables are used. Note if
a vector is provided, it will be converted to a column matrix.}

\item{thresh_method, thresh_level}{The threshold method and level used in edge
selection. If method is set to be \code{"alpha"}, the edge selection is based on
the critical value of correlation coefficient. If method is set to be
\code{"sparsity"}, the edge selection is based on the quantile of correlation
coefficient, thus network sparsity is controlled.}

\item{kfolds}{Folds number of cross-validation. If \code{NULL}, it will be set to
be equal to the number of observations, i.e., leave-one-subject-out.}

\item{bias_correct}{Logical value indicating if the connectome data should be
bias-corrected. If \code{TRUE}, the connectome data will be centered and scaled
to have unit variance based on the training data before model fitting and
prediction. See Rapuano et al. (2020) for more details.}

\item{return_edges}{A character string indicating the return value of the
selected edges. If \code{"none"}, no edges are returned. If \code{"sum"}, the sum of
selected edges across folds is returned. If \code{"all"}, the selected edges for
each fold is returned, which is a 3D array and memory-consuming.}
}
\value{
A list with the following components:

\item{folds}{The corresponding fold for each observation when used as test
group in cross-validation.}

\item{real}{The real behavior data. This is the same as the input \code{behav}
if \code{confounds} is \code{NULL}, otherwise it is the residual of \code{behav} after
regressing out \code{confounds}.}

\item{pred}{The predicted behavior data, with each column corresponding to
a model, i.e., both edges, positive edges, negative edges, and the row
names corresponding to the observation names (the same as those of
\code{behav}).}

\item{edges}{The selected edges, if \code{return_edges} is not \code{"none"}. If
\code{return_edges} is \code{"sum"}, it is a matrix with rows corresponding to
edges and columns corresponding to networks. If \code{return_edges} is
\code{"all"}, it is a 3D array with dimensions corresponding to folds, edges,
and networks.}
}
\description{
The connectome-based predictive modeling (CPM) is a data-driven approach to
predict individual behavior from brain connectivity data. Originally proposed
by Shen et al. (2017), the CPM has been widely used in various studies. This
function implements the CPM algorithm and provides a convenient interface to
use it.
}
\examples{
conmat <- matrix(rnorm(100 * 100), nrow = 100)
behav <- rnorm(100)
cpm(conmat, behav)
# use different threshold method and level
cpm(conmat, behav, thresh_method = "sparsity", thresh_level = 0.05)
# use a 10-fold cross-validation
cpm(conmat, behav, kfolds = 10)
}
\references{
Shen, X., Finn, E. S., Scheinost, D., Rosenberg, M. D., Chun, M. M.,
Papademetris, X., & Constable, R. T. (2017). Using connectome-based
predictive modeling to predict individual behavior from brain connectivity.
Nature Protocols, 12(3), 506–518. https://doi.org/10.1038/nprot.2016.178

Rapuano, K. M., Rosenberg, M. D., Maza, M. T., Dennis, N. J., Dorji, M.,
Greene, A. S., Horien, C., Scheinost, D., Todd Constable, R., & Casey, B. J.
(2020). Behavioral and brain signatures of substance use vulnerability in
childhood. Developmental Cognitive Neuroscience, 46, 100878.
https://doi.org/10.1016/j.dcn.2020.100878
}
