% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv(MA).R
\name{PELT.MVma}
\alias{PELT.MVma}
\title{Most recent changepoints from MV method using censored MA timeseries.}
\usage{
PELT.MVma(data, beta = 101 * log(dim(data)[2]))
}
\arguments{
\item{data}{a censored data matrix obtained from MA1.data .}

\item{beta}{default 101*log(dim(data)[2])). Here dim(data)[2] means consider
size(length) of series (n).}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints from MV methd (Lavielle and Teyssiere, 2006) deal with
multivariate data which is modeling the data within each segment as a
 multivariate (MV) Gaussian having a given covariance
 after generating
 censored data from MA model.
}
\examples{
# example
library(cpcens)
# The size of series(n) shoul be greater than 200.
sim=MA1.data(n = 500, N = 100, K = 5, eps = 1,
 rho = 0.6, mu = 0, siga = 1, rates = c(NA, 0.2), Mrate = 0)
data=sim$data
N=100
pmv = PELT.MVma( data , 101*log(dim(data)[2]) )
mv.chpts =  rep( rev( pmv$cpts )[1] , N )
}
\seealso{
MA1.data
}
