% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{process_internal}
\alias{process_internal}
\title{Internal Shared Regional Dataset Processing}
\usage{
process_internal(
  clean_data,
  level,
  group_vars,
  totals = FALSE,
  localise = TRUE,
  verbose = TRUE,
  process_fns
)
}
\arguments{
\item{clean_data}{The clean data for a class, e.g. \code{Italy$data$clean}}

\item{level}{The level of the data, e.g. 'level_1_region'}

\item{group_vars}{Grouping variables, used to
for grouping and to localise names. It is assumed that the first entry
indicates the main region variable and the second indicates the geocode for
this variable.}

\item{totals}{Logical, defaults to \code{FALSE}. If `TRUE``, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{localise}{Logical, defaults to \code{TRUE}. Should region names be
localised.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose processing
messages and warnings be returned.}

\item{process_fns}{array, additional functions to be called after default
processing steps}
}
\description{
Internal shared regional data cleaning designed to be called
by \code{process}.
}
\seealso{
Functions used in the processing pipeline
\code{\link{run_default_processing_fns}()},
\code{\link{run_optional_processing_fns}()}
}
\concept{processing}
\concept{utility}
