% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LedoitWolf2002.R
\name{LedoitWolf2002}
\alias{LedoitWolf2002}
\title{Test of Structure of a Covariance Matrix given by Ledoit and Wolf 2002}
\usage{
LedoitWolf2002(x, Sigma = "identity", ...)
}
\arguments{
\item{x}{data}

\item{Sigma}{Population covariance matrix}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of equality of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of equality of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Test of Structure of a Covariance Matrix given by Ledoit and Wolf 2002
}
\details{
The \code{\link{structureCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
LedoitWolf2002(as.matrix(iris[1:50, 1:3]))

}
\references{
Ledoit, O., and Wolf, M. (2002). Some Hypothesis Tests 
for the Covariance Matrix When the Dimension Is Large Compared to 
the Sample Size. The Annals of Statistics, 30(4), 1081-1102. 
\href{http://doi.org/10.1214/aos/1031689018}{10.1214/aos/1031689018}
}
