% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_IMA.R
\name{RunIMA}
\alias{RunIMA}
\title{Perform integer matrix approximation on count matrix.}
\usage{
RunIMA(
  C,
  features,
  u_bounds,
  l_bounds = c(0, 0),
  maxiter = 1e+06,
  stop_crit = 1e-04,
  subsample = TRUE
)
}
\arguments{
\item{C}{countland object}

\item{features}{target number of features, integer}

\item{u_bounds}{upper bounds for U and V matrices, vector of length 2}

\item{l_bounds}{lower bounds for U and V matrices, vector of length 2 (default=c(0,0))}

\item{maxiter}{maximum number of iterations, integer (default=1000000)}

\item{stop_crit}{criterion for stopping based on difference between iterations, numeric (default=0.0001)}

\item{subsample}{if TRUE, use subsampled counts (default), otherwise use counts}
}
\value{
countland object with slots \code{matrixU}, \code{matrixV}, \code{matrixLambda}
}
\description{
Perform integer matrix approximation on count matrix.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- RunIMA(C,features=10,u_bounds=c(10,10),subsample=FALSE)
}
