% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_embed.R
\name{Embed}
\alias{Embed}
\title{Perform spectral embedding on dot products.}
\usage{
Embed(C, n_components = 10)
}
\arguments{
\item{C}{countland object}

\item{n_components}{number of components, integer (default=10)}
}
\value{
countland object with slot \code{embedding}, \code{eigenvals}
}
\description{
Perform spectral embedding on dot products.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- Dot(C)
C <- Embed(C,n_components=5)
}
