% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineartransform.R
\name{lineartransform}
\alias{lineartransform}
\title{Linearly transform one scale into another scale.}
\usage{
lineartransform(futureRange = c(1, 5), vec = NULL, digits = NULL)
}
\arguments{
\item{futureRange}{Vector that shows the range of the new scale, e.g., c(1, 5).}

\item{vec}{A vector which contains the values that shall be transformed to the new scale.}

\item{digits}{A single integer that shows the number of digits, which the transformed values shall get rounded to.}
}
\value{
a vector with the linearly transformed new values, rounded to how many digits the user has set the function argument 'digits'.
}
\description{
Transform the values of a variable into other values, by using the linear model. Additionally, select the number of decimal digits of the transformed values.
}
\examples{
someValues <- stats::rnorm(n=10)
# Linearly transform to values between 1 and 5, rounded to zero digits.
lineartransform(futureRange = c(1, 5), vec = someValues, digits = 0)
}
\references{
\href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/lm.html}{lm; linear model command from the stats package}
}
\author{
Marcel Miché
}
