% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{coef.corregp}
\alias{coef.corregp}
\alias{coefficients.corregp}
\title{Extracting Coefficients from Correspondence Regression}
\usage{
\method{coef}{corregp}(object, parm = "x", axes = NULL, ...)

\method{coefficients}{corregp}(object, parm = "x", axes = NULL, ...)
}
\arguments{
\item{object}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to extract the coefficients. Can be either \code{"y"}, \code{"x"}, or any vector of term names in X, level names in X or
level names in Y. Defaults to \code{"x"}.}

\item{axes}{The axes for which to extract the coefficients: a vector of indices. Defaults to all the axes.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A matrix or vector with coefficients (i.e. scores) for the parameters and axes of interest.
}
\description{
Method to extract the coefficients (i.e. scores) of a correspondence regression.
}
\details{
The coefficients in correspondence regression are the same as the coordinate scores.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
coef(haireye.crg, parm = c("Hair", "Sex"), axes = 1:2)
coefficients(haireye.crg, parm = c("Hair", "Sex"), axes = 1:2)
}
}
\seealso{
\code{\link{fitted.corregp}}, \code{\link{residuals.corregp}}.
}
