% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cell3d.corregp}
\alias{cell3d}
\alias{cell3d.corregp}
\title{3D Confidence Ellipsoids for Correspondence Regression}
\usage{
\method{cell3d}{corregp}(object, parm = "x", axes = 1:3, cl = 0.95, ...)

cell3d(object, ...)
}
\arguments{
\item{object}{The output of a call to \code{\link{corregp}} (i.e. an object of class "corregp").}

\item{parm}{The parameter for which to compute the confidence ellipsoids. Can be either \code{"y"}, \code{"x"}, or any vector of term names in X, level names in X or
level names in Y. Defaults to \code{"x"}.}

\item{axes}{The axes for which to compute the confidence ellipsoids: a vector of three values. Defaults to the first three axes.}

\item{cl}{The confidence level for the confidence ellipsoids. Defaults to \code{0.95}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list containing coordinate points for each confidence ellipsoid of interest.
}
\description{
Method to compute 3D confidence ellipsoids for coordinates in correspondence regression.
}
\details{
\code{cell3d} (of a \code{corregp} output) makes use of \code{\link[rgl]{ellipse3d}} from the package \pkg{rgl}.

Typically, \code{cell3d} is not so much used directly as it is called by a \code{\link{plot3d.corregp}} command.
}
\examples{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
cell3d(haireye.crg, parm = "y")
cell3d(haireye.crg, parm = c("Hair", "Sex"))
}
\seealso{
\code{\link{plot3d.corregp}}.
}

