% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_prob_functions.R
\name{ppfunc}
\alias{ppfunc}
\title{Find PPs of SNPs from Z-scores}
\usage{
ppfunc(z, V, W = 0.2)
}
\arguments{
\item{z}{Vector of marginal Z-scores}

\item{V}{Variance of the estimated effect size (can be obtained using Var.beta.cc function)}

\item{W}{Prior for the standard deviation of the effect size parameter, beta (W = 0.2 default)}
}
\value{
Vector of posterior probabilities
}
\description{
Posterior probabilities of causality from marginal Z-scores
}
\details{
This function converts Z-scores to posterior probabilities of causality
i.e. not including the null model of no genetic effects,
so that the sum of the posterior probabilities for all variants is 1
}
\examples{

set.seed(1)
nsnps = 100
N0 = 5000
N1 = 5000
z_scores <- rnorm(nsnps, 0, 3)

## generate example LD matrix and MAFs
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
maf <- colMeans(X)

varbeta <- Var.data.cc(f = maf, N = N0+N1, s = N1/(N0+N1))

res <- ppfunc(z = z_scores, V = varbeta)
sum(res)
res

}
