% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{.test}
\alias{.test}
\title{Single-split test}
\usage{
.test(y, cutoff, X, alpha = 1, type.measure = "deviance")
}
\arguments{
\item{y}{continuous outcome\strong{:}
vector of length \eqn{n}}

\item{cutoff}{cut-off point for dichotomising outcome into classes\strong{:}
\emph{meaningful} value between \code{min(y)} and \code{max(y)}}

\item{X}{features\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{alpha}{elastic net mixing parameter\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{type.measure}{loss function for binary classification\strong{:}
character \code{"deviance"}, \code{"mse"}, \code{"mae"},
or \code{"class"} (see \code{\link[glmnet]{cv.glmnet}})}
}
\description{
Compares models for a continuous response with a cut-off value.
}
\details{
Splits samples into \eqn{80} percent for training
and \eqn{20} percent for testing,
calculates squared deviance residuals of logistic and combined regression,
conducts the paired one-sided Wilcoxon signed rank test,
and returns the \eqn{p}-value.
For the multi-split test,
use the median \eqn{p}-value from \eqn{50} single-split tests
(van de Wiel 2009).
}
\examples{
n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
cornet:::.test(y=y,cutoff=0,X=X)

}
