% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosine.r
\name{cosine}
\alias{cosine}
\alias{tcosine}
\title{Cosine Similarity}
\usage{
cosine(x, y, use = "everything", inverse = FALSE)

tcosine(x, y, use = "everything", inverse = FALSE)
}
\arguments{
\item{x}{A numeric dataframe/matrix or vector.}

\item{y}{A vector (when \code{x} is a vector) or missing (blank) when 
\code{x} is a matrix.}

\item{use}{The NA handler, as in R's \code{cov()} and \code{cor()}
functions.  Options are "everything", "all.obs", and 
"complete.obs".}

\item{inverse}{Logical; should the inverse covariance matrix be returned?}
}
\value{
The \eqn{n\times n} matrix of all pair-wise vector cosine
similarities of the columns.
}
\description{
Compute the cosine similarity matrix efficiently.  The function
syntax and behavior is largely modeled after that of the
\code{cosine()} function from the \code{lsa} package, although
with a very different implementation.
}
\details{
See \code{?coop-package} for implementation details.
}
\examples{
x <- matrix(rnorm(10*3), 10, 3)

coop::cosine(x)
coop::cosine(x[, 1], x[, 2])

}
\author{
Drew Schmidt
}
\seealso{
\code{\link{sparsity}}
}

