% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{remove_cookie}
\alias{remove_cookie}
\title{Remove a cookie}
\usage{
remove_cookie(cookie_name, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{cookie_name}{The name of the cookie. Can contain any US-ASCII
characters except for: the control character, space, a tab, or separator
characters like ( ) < > @ , ; : \\ " / [ ] ? = \{ \}.}

\item{session}{Session from which to make a child scope (the default should
almost always be used).}
}
\value{
A call to \code{session$sendCustomMessage()} which removes the targeted
cookie.
}
\description{
Instruct the user's browser to remove a cookie via JavaScript.
}
\examples{
server <- function(input, output, server) {
  shiny::observeEvent(
    input$button_that_removes_cookie,
    remove_cookie("my_cookie")
  )
}
}
