% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyzenga.R
\name{svyzenga}
\alias{svyzenga}
\alias{svyzenga.DBIsvydesign}
\alias{svyzenga.survey.design}
\alias{svyzenga.svyrep.design}
\title{Zenga index}
\usage{
svyzenga(formula, design, ...)

\method{svyzenga}{survey.design}(formula, design, na.rm = FALSE, ...)

\method{svyzenga}{svyrep.design}(formula, design, na.rm = FALSE, ...)

\method{svyzenga}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable.}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Zenga index, a measure of inequality
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
\dontrun{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

# subset all designs to positive income and non-missing records only
des_eusilc_pos_inc <- subset( des_eusilc , eqincome > 0 )
des_eusilc_rep_pos_inc <- subset( des_eusilc_rep , eqincome > 0 )


# variable without missing values
svyzenga(~eqincome, des_eusilc_pos_inc)
svyzenga(~eqincome, des_eusilc_rep_pos_inc)

# subsetting:
svyzenga(~eqincome, subset( des_eusilc_pos_inc, db040 == "Styria"))
svyzenga(~eqincome, subset( des_eusilc_rep_pos_inc, db040 == "Styria"))

# variable with with missings (but subsetted to remove negatives)
# svyzenga(~py010n, subset( des_eusilc, py010n > 0 | is.na(py010n)) )
# svyzenga(~py010n, subset( des_eusilc_rep, py010n > 0 | is.na(py010n)) )

# svyzenga(~py010n, subset( des_eusilc, py010n > 0 | is.na(py010n)), na.rm = TRUE)
# svyzenga(~py010n, subset( des_eusilc_rep, py010n > 0 | is.na(py010n)), na.rm = TRUE)


# library(MonetDBLite) is only available on 64-bit machines,
# so do not run this block of code in 32-bit R

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )


# subset all designs to positive income and non-missing records only
dbd_eusilc_pos_inc <- subset( dbd_eusilc , eqincome > 0 )

# variable without missing values
svyzenga(~eqincome, dbd_eusilc_pos_inc)

# subsetting:
svyzenga(~eqincome, subset( dbd_eusilc_pos_inc, db040 == "Styria"))

# variable with with missings (but subsetted to remove negatives)
# svyzenga(~py010n, subset( dbd_eusilc, py010n > 0 | is.na(py010n)) )

# svyzenga(~py010n, subset( dbd_eusilc, py010n > 0 | is.na(py010n)), na.rm = TRUE)

dbRemoveTable( conn , 'eusilc' )

}

}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\references{
Matti Langel (2012). Measuring inequality in finite population sampling.
PhD thesis: Universite de Neuchatel,
URL \url{https://doc.rero.ch/record/29204/files/00002252.pdf}.
}
\seealso{
\code{\link{svygini}}
}
\keyword{survey}

