% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyqsr.R
\name{svyqsr}
\alias{svyqsr}
\alias{svyqsr.DBIsvydesign}
\alias{svyqsr.survey.design}
\alias{svyqsr.svyrep.design}
\title{Quintile Share Ratio}
\usage{
svyqsr(formula, design, ...)

\method{svyqsr}{survey.design}(formula, design, alpha = 0.2, na.rm = FALSE,
  upper_quant = FALSE, lower_quant = FALSE, upper_tot = FALSE,
  lower_tot = FALSE, ...)

\method{svyqsr}{svyrep.design}(formula, design, alpha = 0.2, na.rm = FALSE,
  upper_quant = FALSE, lower_quant = FALSE, upper_tot = FALSE,
  lower_tot = FALSE, ...)

\method{svyqsr}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{alpha}{order of the quintile ratio}

\item{na.rm}{Should cases with missing values be dropped?}

\item{upper_quant}{return the lower bound of highest earners}

\item{lower_quant}{return the upper bound of lowest earners}

\item{upper_tot}{return the highest earners total}

\item{lower_tot}{return the lowest earners total}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate ratio of the total income received by the highest earners to the total income received by lowest earners, defaulting to 20%.
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\examples{
\dontrun{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

svyqsr( ~eqincome , design = des_eusilc, upper_tot = TRUE, lower_tot = TRUE )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

svyqsr( ~eqincome , design = des_eusilc_rep, upper_tot = TRUE, lower_tot = TRUE )

# linearized design using a variable with missings
svyqsr( ~ py010n , design = des_eusilc )
svyqsr( ~ py010n , design = des_eusilc , na.rm = TRUE )
# replicate-weighted design using a variable with missings
svyqsr( ~ py010n , design = des_eusilc_rep )
svyqsr( ~ py010n , design = des_eusilc_rep , na.rm = TRUE )

# library(MonetDBLite) is only available on 64-bit machines,
# so do not run this block of code in 32-bit R

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 , 
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

svyqsr( ~ eqincome , design = dbd_eusilc )

dbRemoveTable( conn , 'eusilc' )

}

}
\author{
Djalma Pessoa and Anthony Damico
}
\references{
Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{http://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{http://www5.statcan.gc.ca/bsolc/olc-cel/olc-cel?lang=eng&catno=12-001-X19990024882}.
}
\seealso{
\code{\link{svyarpt}}
}
\keyword{survey}

